/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.ejml;

import java.io.IOException;
import org.ejml.data.ZMatrix;
import us.hebi.matlab.mat.ejml.AbstractMatrixWrapper;
import us.hebi.matlab.mat.format.Mat5Type;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Sink;

class ZMatrixWrapper
extends AbstractMatrixWrapper<ZMatrix> {
    @Override
    protected int getMat5DataSize() {
        return 2 * Mat5Type.Double.computeSerializedSize(this.getNumElements());
    }

    @Override
    protected void writeMat5Data(Sink sink) throws IOException {
        int row;
        int col;
        Mat5Type.Double.writeTag(this.getNumElements(), sink);
        for (col = 0; col < ((ZMatrix)this.matrix).getNumCols(); ++col) {
            for (row = 0; row < ((ZMatrix)this.matrix).getNumRows(); ++row) {
                sink.writeDouble(((ZMatrix)this.matrix).getReal(row, col));
            }
        }
        Mat5Type.Double.writePadding(this.getNumElements(), sink);
        Mat5Type.Double.writeTag(this.getNumElements(), sink);
        for (col = 0; col < ((ZMatrix)this.matrix).getNumCols(); ++col) {
            for (row = 0; row < ((ZMatrix)this.matrix).getNumRows(); ++row) {
                sink.writeDouble(((ZMatrix)this.matrix).getImag(row, col));
            }
        }
        Mat5Type.Double.writePadding(this.getNumElements(), sink);
    }

    public MatlabType getType() {
        return MatlabType.Double;
    }

    ZMatrixWrapper(ZMatrix matrix) {
        super(matrix);
    }

    @Override
    public boolean isComplex() {
        return true;
    }
}

