/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.ejml;

import java.io.IOException;
import org.ejml.data.CMatrix;
import us.hebi.matlab.mat.ejml.AbstractMatrixWrapper;
import us.hebi.matlab.mat.format.Mat5Type;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Sink;

class CMatrixWrapper
extends AbstractMatrixWrapper<CMatrix> {
    @Override
    protected int getMat5DataSize() {
        return 2 * Mat5Type.Single.computeSerializedSize(this.getNumElements());
    }

    @Override
    protected void writeMat5Data(Sink sink) throws IOException {
        int row;
        int col;
        Mat5Type.Single.writeTag(this.getNumElements(), sink);
        for (col = 0; col < ((CMatrix)this.matrix).getNumCols(); ++col) {
            for (row = 0; row < ((CMatrix)this.matrix).getNumRows(); ++row) {
                sink.writeFloat(((CMatrix)this.matrix).getReal(row, col));
            }
        }
        Mat5Type.Single.writePadding(this.getNumElements(), sink);
        Mat5Type.Single.writeTag(this.getNumElements(), sink);
        for (col = 0; col < ((CMatrix)this.matrix).getNumCols(); ++col) {
            for (row = 0; row < ((CMatrix)this.matrix).getNumRows(); ++row) {
                sink.writeFloat(((CMatrix)this.matrix).getImag(row, col));
            }
        }
        Mat5Type.Single.writePadding(this.getNumElements(), sink);
    }

    public MatlabType getType() {
        return MatlabType.Double;
    }

    CMatrixWrapper(CMatrix matrix) {
        super(matrix);
    }

    @Override
    public boolean isComplex() {
        return true;
    }
}

