/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.ejml;

import java.io.IOException;
import org.ejml.data.CMatrix;
import org.ejml.data.Matrix;
import us.hebi.matlab.mat.ejml.CMatrixWrapper;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5Serializable;
import us.hebi.matlab.mat.format.Mat5WriteUtil;
import us.hebi.matlab.mat.types.AbstractArray;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Sink;

abstract class AbstractMatrixWrapper<M extends Matrix>
extends AbstractArray
implements Mat5Serializable,
Mat5Serializable.Mat5Attributes {
    protected final M matrix;

    public int getMat5Size(String name) {
        return 8 + Mat5WriteUtil.computeArrayHeaderSize((String)name, (Array)this) + this.getMat5DataSize();
    }

    public void writeMat5(String name, boolean isGlobal, Sink sink) throws IOException {
        Mat5WriteUtil.writeMatrixTag((String)name, (Mat5Serializable)this, (Sink)sink);
        Mat5WriteUtil.writeArrayHeader((String)name, (boolean)isGlobal, (Array)this, (Sink)sink);
        this.writeMat5Data(sink);
    }

    protected abstract int getMat5DataSize();

    protected abstract void writeMat5Data(Sink var1) throws IOException;

    public boolean isLogical() {
        return false;
    }

    public boolean isComplex() {
        return false;
    }

    public int getNzMax() {
        return 0;
    }

    public int[] getDimensions() {
        this.dims[0] = this.matrix.getNumRows();
        this.dims[1] = this.matrix.getNumCols();
        return this.dims;
    }

    public void close() throws IOException {
    }

    protected int subHashCode() {
        return this.matrix.hashCode();
    }

    protected boolean subEqualsGuaranteedSameClass(Object otherGuaranteedSameClass) {
        CMatrixWrapper other = (CMatrixWrapper)((Object)otherGuaranteedSameClass);
        return ((CMatrix)other.matrix).equals(this.matrix);
    }

    protected AbstractMatrixWrapper(M matrix) {
        super(Mat5.dims((int)matrix.getNumRows(), (int)matrix.getNumCols()));
        this.matrix = matrix;
    }
}

