/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Axis;
import tech.tablesaw.plotly.components.Font;
import tech.tablesaw.plotly.components.Grid;
import tech.tablesaw.plotly.components.Margin;
import tech.tablesaw.plotly.components.TemplateUtils;
import tech.tablesaw.plotly.components.threeD.Scene;

public class Layout {
    private static final int DEFAULT_HEIGHT = 600;
    private static final int DEFAULT_WIDTH = 800;
    private static final String DEFAULT_TITLE = "";
    private static final String DEFAULT_PAPER_BG_COLOR = "#fff";
    private static final String DEFAULT_PLOT_BG_COLOR = "#fff";
    private static final String DEFAULT_DECIMAL_SEPARATOR = ".";
    private static final String DEFAULT_THOUSANDS_SEPARATOR = ",";
    private static final boolean DEFAULT_AUTO_SIZE = false;
    private static final HoverMode DEFAULT_HOVER_MODE = HoverMode.FALSE;
    private static final DragMode DEFAULT_DRAG_MODE = DragMode.ZOOM;
    private static final int DEFAULT_HOVER_DISTANCE = 20;
    private static final BarMode DEFAULT_BAR_MODE = BarMode.GROUP;
    private static final Font DEFAULT_TITLE_FONT = Font.builder().build();
    private static final Font DEFAULT_FONT = Font.builder().build();
    private final PebbleEngine engine = TemplateUtils.getNewEngine();
    private final Scene scene;
    private final Font font;
    private final String title;
    private final Font titleFont;
    private final boolean autoSize;
    private final boolean heightSet;
    private final boolean widthSet;
    private final int width;
    private final int height;
    private final Margin margin;
    private final String paperBgColor;
    private final String plotBgColor;
    private final String decimalSeparator;
    private final String thousandsSeparator;
    private final Boolean showLegend;
    private final HoverMode hoverMode;
    private final DragMode dragMode;
    private final int hoverDistance;
    private final Axis xAxis;
    private final Axis yAxis;
    private final Axis yAxis2;
    private final Axis yAxis3;
    private final Axis yAxis4;
    private final Axis zAxis;
    private final Grid grid;
    private final BarMode barMode;

    private Layout(LayoutBuilder builder) {
        this.title = builder.title;
        this.autoSize = builder.autoSize;
        this.widthSet = builder.widthSet;
        this.heightSet = builder.heightSet;
        this.decimalSeparator = DEFAULT_DECIMAL_SEPARATOR;
        this.thousandsSeparator = DEFAULT_THOUSANDS_SEPARATOR;
        this.dragMode = builder.dragMode;
        this.font = builder.font;
        this.titleFont = builder.titleFont;
        this.hoverDistance = builder.hoverDistance;
        this.hoverMode = builder.hoverMode;
        this.margin = builder.margin;
        this.height = builder.height;
        this.width = builder.width;
        this.xAxis = builder.xAxis;
        this.yAxis = builder.yAxis;
        this.zAxis = builder.zAxis;
        this.yAxis2 = builder.yAxis2;
        this.yAxis3 = builder.yAxis3;
        this.yAxis4 = builder.yAxis4;
        this.paperBgColor = builder.paperBgColor;
        this.plotBgColor = builder.plotBgColor;
        this.showLegend = builder.showLegend;
        this.barMode = builder.barMode;
        this.scene = builder.scene;
        this.grid = builder.grid;
    }

    public String getTitle() {
        return this.title;
    }

    public String asJavascript() {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("layout_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ((Object)writer).toString();
    }

    protected Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (!this.title.equals(DEFAULT_TITLE)) {
            context.put("title", this.title);
        }
        if (!this.titleFont.equals(DEFAULT_TITLE_FONT)) {
            context.put("titlefont", this.titleFont);
        }
        if (!this.font.equals(DEFAULT_FONT)) {
            context.put("font", this.font);
        }
        if (this.autoSize) {
            context.put("autosize", this.autoSize);
            if (this.widthSet) {
                context.put("width", this.width);
            }
            if (this.heightSet) {
                context.put("height", this.height);
            }
        } else {
            context.put("width", this.width);
            context.put("height", this.height);
        }
        if (this.hoverDistance != 20) {
            context.put("hoverdistance", this.hoverDistance);
        }
        if (!this.hoverMode.equals((Object)DEFAULT_HOVER_MODE)) {
            context.put("hoverMode", (Object)this.hoverMode);
        }
        if (this.margin != null) {
            context.put("margin", this.margin);
        }
        if (!this.decimalSeparator.equals(DEFAULT_DECIMAL_SEPARATOR)) {
            context.put("decimalSeparator", this.decimalSeparator);
        }
        if (!this.thousandsSeparator.equals(DEFAULT_THOUSANDS_SEPARATOR)) {
            context.put("thousandsSeparator", this.thousandsSeparator);
        }
        if (!this.dragMode.equals((Object)DEFAULT_DRAG_MODE)) {
            context.put("dragmode", (Object)this.dragMode);
        }
        if (this.showLegend != null) {
            context.put("showlegend", this.showLegend);
        }
        if (!this.plotBgColor.equals("#fff")) {
            context.put("plotbgcolor", this.plotBgColor);
        }
        if (!this.paperBgColor.equals("#fff")) {
            context.put("paperbgcolor", this.paperBgColor);
        }
        if (!this.barMode.equals((Object)DEFAULT_BAR_MODE)) {
            context.put("barMode", (Object)this.barMode);
        }
        if (this.scene != null) {
            context.put("scene", this.scene);
        }
        if (this.xAxis != null) {
            context.put("xAxis", this.xAxis);
        }
        if (this.yAxis != null) {
            context.put("yAxis", this.yAxis);
        }
        if (this.yAxis2 != null) {
            context.put("yAxis2", this.yAxis2);
        }
        if (this.yAxis3 != null) {
            context.put("yAxis3", this.yAxis3);
        }
        if (this.yAxis4 != null) {
            context.put("yAxis4", this.yAxis4);
        }
        if (this.zAxis != null) {
            context.put("zAxis", this.zAxis);
        }
        if (this.grid != null) {
            context.put("grid", this.grid);
        }
        return context;
    }

    public static LayoutBuilder builder() {
        return new LayoutBuilder();
    }

    public static LayoutBuilder builder(String title) {
        return Layout.builder().title(title).height(600).width(800);
    }

    public static LayoutBuilder builder(String title, String xTitle) {
        return Layout.builder(title).xAxis(Axis.builder().title(xTitle).build());
    }

    public static LayoutBuilder builder(String title, String xTitle, String yTitle) {
        return Layout.builder(title, xTitle).yAxis(Axis.builder().title(yTitle).build());
    }

    static /* synthetic */ Font access$2500() {
        return DEFAULT_FONT;
    }

    static /* synthetic */ Font access$2600() {
        return DEFAULT_TITLE_FONT;
    }

    static /* synthetic */ HoverMode access$2700() {
        return DEFAULT_HOVER_MODE;
    }

    static /* synthetic */ DragMode access$2800() {
        return DEFAULT_DRAG_MODE;
    }

    static /* synthetic */ BarMode access$2900() {
        return DEFAULT_BAR_MODE;
    }

    public static class LayoutBuilder {
        private final Font font = Layout.access$2500();
        private String title = "";
        private Font titleFont = Layout.access$2600();
        private boolean autoSize = false;
        private boolean widthSet = false;
        private boolean heightSet = false;
        private int width = 700;
        private int height = 450;
        private Margin margin;
        private String paperBgColor = "#fff";
        private String plotBgColor = "#fff";
        private final String decimalSeparator = ".";
        private final String thousandsSeparator = ",";
        private Boolean showLegend = null;
        private HoverMode hoverMode = Layout.access$2700();
        private final DragMode dragMode = Layout.access$2800();
        private int hoverDistance = 20;
        private Axis xAxis;
        private Axis yAxis;
        private Axis yAxis2;
        private Axis yAxis3;
        private Axis yAxis4;
        private Axis zAxis;
        private BarMode barMode = Layout.access$2900();
        private Scene scene;
        private Grid grid;

        public Layout build() {
            return new Layout(this);
        }

        private LayoutBuilder() {
        }

        public LayoutBuilder title(String title) {
            this.title = title;
            return this;
        }

        public LayoutBuilder titleFont(Font titleFont) {
            this.titleFont = titleFont;
            return this;
        }

        public LayoutBuilder barMode(BarMode barMode) {
            this.barMode = barMode;
            return this;
        }

        public LayoutBuilder margin(Margin margin) {
            this.margin = margin;
            return this;
        }

        public LayoutBuilder scene(Scene scene) {
            this.scene = scene;
            return this;
        }

        public LayoutBuilder hoverMode(HoverMode hoverMode) {
            this.hoverMode = hoverMode;
            return this;
        }

        public LayoutBuilder hoverDistance(int distance) {
            this.hoverDistance = distance;
            return this;
        }

        public LayoutBuilder showLegend(boolean showLegend) {
            this.showLegend = showLegend;
            return this;
        }

        public LayoutBuilder height(int height) {
            this.height = height;
            this.heightSet = true;
            return this;
        }

        public LayoutBuilder width(int width) {
            this.width = width;
            this.widthSet = true;
            return this;
        }

        public LayoutBuilder autosize(boolean autosize) {
            this.autoSize = autosize;
            return this;
        }

        public LayoutBuilder xAxis(Axis axis) {
            this.xAxis = axis;
            return this;
        }

        public LayoutBuilder yAxis(Axis axis) {
            this.yAxis = axis;
            return this;
        }

        public LayoutBuilder yAxis2(Axis axis) {
            this.yAxis2 = axis;
            return this;
        }

        public LayoutBuilder yAxis3(Axis axis) {
            this.yAxis3 = axis;
            return this;
        }

        public LayoutBuilder yAxis4(Axis axis) {
            this.yAxis4 = axis;
            return this;
        }

        public LayoutBuilder zAxis(Axis axis) {
            this.zAxis = axis;
            return this;
        }

        public LayoutBuilder plotBgColor(String color) {
            this.plotBgColor = color;
            return this;
        }

        public LayoutBuilder paperBgColor(String color) {
            this.paperBgColor = color;
            return this;
        }

        public LayoutBuilder grid(Grid grid) {
            this.grid = grid;
            return this;
        }
    }

    public static enum DragMode {
        ZOOM("zoom"),
        PAN("pan"),
        SELECT("select"),
        LASSO("lasso"),
        ORBIT("orbit"),
        TURNTABLE("turntable");

        private final String value;

        private DragMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum BarMode {
        STACK("stack"),
        GROUP("group"),
        OVERLAY("overlay"),
        RELATIVE("relative");

        private final String value;

        private BarMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum HoverMode {
        X("x"),
        Y("y"),
        CLOSEST("closest"),
        FALSE("false");

        private final String value;

        private HoverMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

