/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.internal.repository;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import tech.ailef.snapadmin.external.dto.LogsSearchRequest;
import tech.ailef.snapadmin.internal.model.UserAction;
import tech.ailef.snapadmin.internal.repository.CustomActionRepository;

@Component
public class CustomActionRepositoryImpl
implements CustomActionRepository {
    @PersistenceContext(unitName="internal")
    private EntityManager entityManager;

    @Override
    public List<UserAction> findActions(LogsSearchRequest request) {
        String table = request.getTable();
        String actionType = request.getActionType();
        String username = request.getUsername();
        String itemId = request.getItemId();
        PageRequest page = request.toPageRequest();
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(UserAction.class);
        Root userAction = query.from(UserAction.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (table != null) {
            predicates.add(cb.equal((Expression)userAction.get("onTable"), (Object)table));
        }
        if (actionType != null) {
            predicates.add(cb.equal((Expression)userAction.get("actionType"), (Object)actionType));
        }
        if (itemId != null) {
            predicates.add(cb.equal((Expression)userAction.get("primaryKey"), (Object)itemId));
        }
        if (username != null) {
            predicates.add(cb.equal((Expression)userAction.get("username"), (Object)username));
        }
        if (!predicates.isEmpty()) {
            query.select((Selection)userAction).where((Expression)cb.and(predicates.toArray(new Predicate[predicates.size()])));
        }
        if (request.getSortKey() != null) {
            String key = request.getSortKey();
            if (request.getSortOrder().equalsIgnoreCase("ASC")) {
                query.orderBy(new Order[]{cb.asc((Expression)userAction.get(key))});
            } else {
                query.orderBy(new Order[]{cb.desc((Expression)userAction.get(key))});
            }
        }
        return this.entityManager.createQuery(query).setMaxResults(page.getPageSize()).setFirstResult((int)page.getOffset()).getResultList();
    }

    @Override
    public long countActions(LogsSearchRequest request) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Long.class);
        Root userAction = query.from(UserAction.class);
        String table = request.getTable();
        String actionType = request.getActionType();
        String itemId = request.getItemId();
        String username = request.getUsername();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (table != null) {
            predicates.add(cb.equal((Expression)userAction.get("onTable"), (Object)table));
        }
        if (actionType != null) {
            predicates.add(cb.equal((Expression)userAction.get("actionType"), (Object)actionType));
        }
        if (itemId != null) {
            predicates.add(cb.equal((Expression)userAction.get("primaryKey"), (Object)itemId));
        }
        if (username != null) {
            predicates.add(cb.equal((Expression)userAction.get("username"), (Object)username));
        }
        if (!predicates.isEmpty()) {
            query.select((Selection)cb.count((Expression)userAction)).where((Expression)cb.and(predicates.toArray(new Predicate[predicates.size()])));
        } else {
            query.select((Selection)cb.count((Expression)userAction));
        }
        return (Long)this.entityManager.createQuery(query).getSingleResult();
    }
}

