/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.internal.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import java.time.LocalDateTime;
import org.springframework.format.datetime.standard.DateTimeFormatterFactory;

@Entity
public class UserAction {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @Column(nullable=false)
    private LocalDateTime createdAt;
    @Lob
    @Column(nullable=false)
    private String sql;
    @Column(nullable=false)
    private String javaClass;
    @Column(nullable=false)
    private String onTable;
    @Column(nullable=false)
    private String primaryKey;
    @Column(nullable=false)
    private String actionType;
    @Column(nullable=true)
    private String username;

    public UserAction() {
    }

    public UserAction(String onTable, String primaryKey, String actionType, String javaClass, String username) {
        this.createdAt = LocalDateTime.now();
        this.sql = "SQL TODO";
        this.javaClass = javaClass;
        this.onTable = onTable;
        this.actionType = actionType;
        this.primaryKey = primaryKey;
        this.username = username;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getOnTable() {
        return this.onTable;
    }

    public void setOnTable(String onTable) {
        this.onTable = onTable;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String getFormattedDate() {
        return new DateTimeFormatterFactory("YYYY-MM-dd HH:mm:ss").createDateTimeFormatter().format(this.createdAt);
    }

    public String getJavaClass() {
        return this.javaClass;
    }

    public void setJavaClass(String javaClass) {
        this.javaClass = javaClass;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

