/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import tech.ailef.snapadmin.external.exceptions.SnapAdminException;
import tech.ailef.snapadmin.internal.model.UserSetting;
import tech.ailef.snapadmin.internal.repository.UserSettingsRepository;

@Component
public class UserConfiguration {
    @Autowired
    private UserSettingsRepository repo;

    public String get(String settingName) {
        Optional setting = this.repo.findById(settingName);
        if (setting.isPresent()) {
            return ((UserSetting)setting.get()).getSettingValue();
        }
        String settingDefaultValue = this.defaultValues().get(settingName);
        if (settingDefaultValue == null) {
            throw new SnapAdminException("Trying to access setting `" + settingName + "` but it has no default value");
        }
        return settingDefaultValue;
    }

    private Map<String, String> defaultValues() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("brandName", "SnapAdmin");
        values.put("additionalCss", "");
        return values;
    }
}

