/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.misc;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.util.MultiValueMap;
import tech.ailef.snapadmin.external.dbmapping.DbObjectSchema;
import tech.ailef.snapadmin.external.dbmapping.fields.DbField;
import tech.ailef.snapadmin.external.dto.CompareOperator;
import tech.ailef.snapadmin.external.dto.QueryFilter;
import tech.ailef.snapadmin.external.exceptions.SnapAdminException;

public interface Utils {
    public static String snakeToCamel(String text) {
        boolean shouldConvertNextCharToLower = true;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char currentChar = text.charAt(i);
            if (currentChar == '_') {
                shouldConvertNextCharToLower = false;
                continue;
            }
            if (shouldConvertNextCharToLower) {
                builder.append(Character.toLowerCase(currentChar));
                continue;
            }
            builder.append(Character.toUpperCase(currentChar));
            shouldConvertNextCharToLower = true;
        }
        return builder.toString();
    }

    public static String camelToSnake(String v) {
        if (Character.isUpperCase(((String)v).charAt(0))) {
            v = Character.toLowerCase(((String)v).charAt(0)) + ((String)v).substring(1);
        }
        return ((String)v).replaceAll("([A-Z][a-z])", "_$1").toLowerCase();
    }

    public static Set<QueryFilter> computeFilters(DbObjectSchema schema, MultiValueMap<String, String> params) {
        if (params == null) {
            return new HashSet<QueryFilter>();
        }
        List ops = (List)params.get((Object)"filter_op");
        List fields = (List)params.get((Object)"filter_field");
        List values = (List)params.get((Object)"filter_value");
        if (ops == null || fields == null || values == null) {
            return new HashSet<QueryFilter>();
        }
        if (ops.size() != fields.size() || fields.size() != values.size() || ops.size() != values.size()) {
            throw new SnapAdminException("Filtering parameters must have the same size");
        }
        HashSet<QueryFilter> filters = new HashSet<QueryFilter>();
        for (int i = 0; i < ops.size(); ++i) {
            String op = (String)ops.get(i);
            String field = (String)fields.get(i);
            String value = (String)values.get(i);
            DbField dbField = schema.getFieldByJavaName(field);
            if (dbField == null) continue;
            QueryFilter queryFilter = new QueryFilter(dbField, CompareOperator.valueOf(op.toUpperCase()), value);
            filters.add(queryFilter);
        }
        return filters;
    }

    public static String getQueryString(MultiValueMap<String, String> params) {
        Set currentParams = params.keySet();
        ArrayList<CallSite> paramValues = new ArrayList<CallSite>();
        for (String param : currentParams) {
            for (String v : (List)params.get((Object)param)) {
                paramValues.add((CallSite)((Object)(param + "=" + v.trim())));
            }
        }
        if (paramValues.isEmpty()) {
            return "";
        }
        return "?" + String.join((CharSequence)"&", paramValues);
    }
}

