/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.dto;

import java.util.Objects;
import tech.ailef.snapadmin.external.dbmapping.fields.DbField;
import tech.ailef.snapadmin.external.dto.CompareOperator;
import tech.ailef.snapadmin.external.exceptions.SnapAdminException;

public class QueryFilter {
    private DbField field;
    private CompareOperator op;
    private String value;

    public QueryFilter(DbField field, CompareOperator op, String value) {
        if (field == null) {
            throw new SnapAdminException("Trying to build QueryFilter with null `field`");
        }
        this.field = field;
        this.op = op;
        this.value = value;
    }

    public DbField getField() {
        return this.field;
    }

    public CompareOperator getOp() {
        return this.op;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        if (this.value != null && !this.value.toString().isBlank()) {
            Object displayValue = this.value;
            if (this.value.length() > 18) {
                displayValue = this.value.substring(0, 4) + "..." + this.value.substring(this.value.length() - 4);
            }
            return "'" + this.field.getName() + "' " + this.op.getDisplayName() + " '" + (String)displayValue + "'";
        }
        if (this.op != CompareOperator.STRING_EQ && this.op != CompareOperator.EQ) {
            return "'" + this.field.getName() + "' " + this.op.getDisplayName() + " NULL";
        }
        return "'" + this.field.getName() + "' IS NULL";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.op, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryFilter other = (QueryFilter)obj;
        return Objects.equals(this.field, other.field) && this.op == other.op && Objects.equals(this.value, other.value);
    }
}

