/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.dto;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.util.MultiValueMap;
import tech.ailef.snapadmin.external.dto.FilterRequest;
import tech.ailef.snapadmin.external.misc.Utils;

public class PaginationInfo {
    private static final int PAGE_RANGE = 3;
    private int currentPage;
    private int maxPage;
    private int pageSize;
    private long maxElement;
    private FilterRequest filterRequest;
    private String query;

    public PaginationInfo(int currentPage, int maxPage, int pageSize, long maxElement, String query, FilterRequest request) {
        this.currentPage = currentPage;
        this.maxPage = maxPage;
        this.pageSize = pageSize;
        this.query = query;
        this.maxElement = maxElement;
        this.filterRequest = request;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public void setMaxPage(int maxPage) {
        this.maxPage = maxPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public long getMaxElement() {
        return this.maxElement;
    }

    public String getSortedPageLink(String sortKey, String sortOrder) {
        MultiValueMap<String, String> params = FilterRequest.empty();
        if (this.filterRequest != null) {
            params = this.filterRequest.computeParams();
        }
        if (this.query != null) {
            params.put((Object)"query", new ArrayList());
            ((List)params.get((Object)"query")).add(this.query);
        }
        params.add((Object)"pageSize", (Object)("" + this.pageSize));
        params.add((Object)"page", (Object)("" + this.currentPage));
        params.add((Object)"sortKey", (Object)sortKey);
        params.add((Object)"sortOrder", (Object)sortOrder);
        return Utils.getQueryString(params);
    }

    public String getLink(int page) {
        MultiValueMap<String, String> params = FilterRequest.empty();
        if (this.filterRequest != null) {
            params = this.filterRequest.computeParams();
        }
        if (this.query != null) {
            params.put((Object)"query", new ArrayList());
            ((List)params.get((Object)"query")).add(this.query);
        }
        params.add((Object)"pageSize", (Object)("" + this.pageSize));
        params.add((Object)"page", (Object)("" + page));
        return Utils.getQueryString(params);
    }

    public List<Integer> getBeforePages() {
        return IntStream.range(Math.max(this.currentPage - 3, 1), this.currentPage).boxed().collect(Collectors.toList());
    }

    public List<Integer> getAfterPages() {
        return IntStream.range(this.currentPage + 1, Math.min(this.currentPage + 3, this.maxPage + 1)).boxed().collect(Collectors.toList());
    }

    public boolean isLastPage() {
        return this.currentPage == this.maxPage;
    }
}

