/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.dto;

import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import tech.ailef.snapadmin.external.dto.FilterRequest;

public class LogsSearchRequest
implements FilterRequest {
    private String table;
    private String actionType;
    private String itemId;
    private int page;
    private int pageSize;
    private String sortKey;
    private String sortOrder;
    private String username;

    public String getTable() {
        return this.table == null || this.table.isBlank() || this.table.equalsIgnoreCase("Any") ? null : this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getActionType() {
        return this.actionType == null || this.actionType.isBlank() || this.actionType.equalsIgnoreCase("Any") ? null : this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String getItemId() {
        return this.itemId == null || this.itemId.isBlank() ? null : this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String toString() {
        return "LogsSearchRequest [table=" + this.table + ", actionType=" + this.actionType + ", itemId=" + this.itemId + ", page=" + this.page + ", pageSize=" + this.pageSize + ", sortKey=" + this.sortKey + ", sortOrder=" + this.sortOrder + "]";
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public PageRequest toPageRequest() {
        int actualPageSize;
        int actualPage = this.page - 1 < 0 ? 0 : this.page - 1;
        int n = actualPageSize = this.pageSize <= 0 ? 50 : this.pageSize;
        if (this.sortKey == null) {
            return PageRequest.of((int)actualPage, (int)actualPageSize);
        }
        if (this.sortOrder == null) {
            this.sortOrder = "ASC";
        }
        if (this.sortOrder.equals("DESC")) {
            return PageRequest.of((int)actualPage, (int)actualPageSize, (Sort)Sort.by((String[])new String[]{this.sortKey}).descending());
        }
        return PageRequest.of((int)actualPage, (int)actualPageSize, (Sort)Sort.by((String[])new String[]{this.sortKey}).ascending());
    }

    @Override
    public MultiValueMap<String, String> computeParams() {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        if (this.table != null) {
            params.add((Object)"table", (Object)this.table);
        }
        if (this.itemId != null) {
            params.add((Object)"itemId", (Object)this.itemId);
        }
        if (this.actionType != null) {
            params.add((Object)"actionType", (Object)this.actionType);
        }
        return params;
    }
}

