/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.dbmapping.query;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import tech.ailef.snapadmin.external.SnapAdmin;
import tech.ailef.snapadmin.external.dbmapping.DbObjectSchema;
import tech.ailef.snapadmin.external.dbmapping.fields.DbField;
import tech.ailef.snapadmin.external.dbmapping.fields.DbFieldType;
import tech.ailef.snapadmin.external.dbmapping.query.DbQueryResultRow;
import tech.ailef.snapadmin.external.exceptions.SnapAdminException;
import tech.ailef.snapadmin.external.exceptions.UnsupportedFieldTypeException;

public class DbQueryOutputField {
    private String name;
    private String table;
    private DbField dbField;
    private DbQueryResultRow result;

    public DbQueryOutputField(String name, String table, SnapAdmin snapAdmin) {
        this.name = name;
        this.table = table;
        try {
            DbField dbField;
            DbObjectSchema schema = snapAdmin.findSchemaByTableName(table);
            this.dbField = dbField = schema.getFieldByName(name);
        }
        catch (SnapAdminException snapAdminException) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public String getTable() {
        return this.table;
    }

    public boolean isPrimaryKey() {
        return this.dbField != null && this.dbField.isPrimaryKey();
    }

    public boolean isForeignKey() {
        return this.dbField != null && this.dbField.isForeignKey();
    }

    public boolean isExportable() {
        if (this.dbField == null) {
            return true;
        }
        return this.dbField.isExportable();
    }

    public Class<?> getConnectedType() {
        if (this.dbField == null) {
            return null;
        }
        return this.dbField.getConnectedType();
    }

    public boolean isBinary() {
        return this.dbField != null && this.dbField.isBinary();
    }

    public boolean isMapped() {
        return this.dbField != null;
    }

    public String getType() {
        if (this.dbField != null) {
            return this.dbField.getType().toString();
        }
        if (this.result != null) {
            try {
                DbFieldType type = DbFieldType.fromClass(this.result.get(this).getClass()).getConstructor(new Class[0]).newInstance(new Object[0]);
                return type.toString();
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | UnsupportedFieldTypeException e) {
                return "-";
            }
        }
        return "-";
    }

    public String getJavaName() {
        if (this.dbField == null) {
            return null;
        }
        return this.dbField.getJavaName();
    }

    public String getEntityClassName() {
        if (this.dbField == null) {
            return null;
        }
        return this.dbField.getSchema().getClassName();
    }

    public void setResult(DbQueryResultRow result) {
        this.result = result;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.table);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DbQueryOutputField other = (DbQueryOutputField)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.table, other.table);
    }
}

