/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.dbmapping.fields;

import jakarta.persistence.EnumType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import tech.ailef.snapadmin.external.dbmapping.fields.DbFieldType;
import tech.ailef.snapadmin.external.dto.CompareOperator;
import tech.ailef.snapadmin.external.exceptions.SnapAdminException;

public class EnumFieldType
extends DbFieldType {
    private EnumType type;
    private Class<?> klass;

    public EnumFieldType(Class<?> klass, EnumType type) {
        this.klass = klass;
        this.type = type;
    }

    @Override
    public String getFragmentName() {
        return "select";
    }

    @Override
    public List<?> getValues() {
        try {
            Method method = this.getJavaClass().getMethod("values", new Class[0]);
            Object[] invoke = (Object[])method.invoke(null, new Object[0]);
            return Arrays.stream(invoke).collect(Collectors.toList());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new SnapAdminException(e);
        }
    }

    @Override
    public Object parseValue(Object value) {
        if (value == null || value.toString().isBlank()) {
            return null;
        }
        try {
            Method valueOf = this.getJavaClass().getMethod("valueOf", String.class);
            return valueOf.invoke(null, value.toString());
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                throw new SnapAdminException("Invalid value " + value + " for enum type " + this.getJavaClass().getSimpleName());
            }
            throw new SnapAdminException(e);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException e) {
            throw new SnapAdminException(e);
        }
    }

    @Override
    public Class<?> getJavaClass() {
        return this.klass;
    }

    @Override
    public List<CompareOperator> getCompareOperators() {
        return List.of(CompareOperator.EQ);
    }

    public EnumType getType() {
        return this.type;
    }
}

