/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.dbmapping.fields;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import tech.ailef.snapadmin.external.annotations.DisplayImage;
import tech.ailef.snapadmin.external.annotations.Filterable;
import tech.ailef.snapadmin.external.annotations.FilterableType;
import tech.ailef.snapadmin.external.annotations.ReadOnly;
import tech.ailef.snapadmin.external.dbmapping.DbFieldValue;
import tech.ailef.snapadmin.external.dbmapping.DbObject;
import tech.ailef.snapadmin.external.dbmapping.DbObjectSchema;
import tech.ailef.snapadmin.external.dbmapping.fields.BigIntegerFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.ByteArrayFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.ByteFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.DbFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.EnumFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.IntegerFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.TextFieldType;

public class DbField {
    protected String dbName;
    protected String javaName;
    protected DbFieldType type;
    @JsonIgnore
    protected Field field;
    @JsonIgnore
    private Class<?> connectedType;
    private boolean primaryKey;
    private boolean nullable;
    private String format;
    @JsonIgnore
    private DbObjectSchema schema;

    public DbField(String javaName, String name, Field field, DbFieldType type, DbObjectSchema schema, String format) {
        this.javaName = javaName;
        this.dbName = name;
        this.schema = schema;
        this.field = field;
        this.type = type;
        this.format = format;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public DbObjectSchema getSchema() {
        return this.schema;
    }

    public DbObjectSchema getConnectedSchema() {
        if (this.connectedType == null) {
            return null;
        }
        return this.schema.getSnapAdmin().findSchemaByClass(this.connectedType);
    }

    public void setSchema(DbObjectSchema schema) {
        this.schema = schema;
    }

    @JsonIgnore
    public Field getPrimitiveField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public String getName() {
        return this.dbName;
    }

    public void setName(String name) {
        this.dbName = name;
    }

    public DbFieldType getType() {
        return this.type;
    }

    public void setType(DbFieldType type) {
        this.type = type;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public Class<?> getConnectedType() {
        return this.connectedType;
    }

    public void setConnectedType(Class<?> connectedType) {
        this.connectedType = connectedType;
    }

    public boolean isForeignKey() {
        return this.connectedType != null;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isBinary() {
        return this.type instanceof ByteArrayFieldType;
    }

    public boolean isImage() {
        return this.field.getAnnotation(DisplayImage.class) != null;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isText() {
        return this.type instanceof TextFieldType;
    }

    public String getStep() {
        if (this.getType() instanceof IntegerFieldType || this.getType() instanceof BigIntegerFieldType || this.getType() instanceof ByteFieldType) {
            return "0";
        }
        return "any";
    }

    public String getFragmentName() {
        return this.type.getFragmentName();
    }

    public boolean isFilterable() {
        return this.getPrimitiveField().getAnnotation(Filterable.class) != null;
    }

    public boolean isFilterableCategorical() {
        Filterable filterable = this.getPrimitiveField().getAnnotation(Filterable.class);
        return filterable != null && filterable.type() == FilterableType.CATEGORICAL;
    }

    public boolean isReadOnly() {
        return this.getPrimitiveField().getAnnotation(ReadOnly.class) != null;
    }

    public boolean isToOne() {
        return this.getPrimitiveField().getAnnotation(OneToOne.class) != null && this.getPrimitiveField().getAnnotation(OneToOne.class).mappedBy().isBlank() || this.getPrimitiveField().getAnnotation(ManyToOne.class) != null;
    }

    public boolean isSettable() {
        return this.getPrimitiveField().getAnnotation(ManyToOne.class) == null && this.getPrimitiveField().getAnnotation(OneToMany.class) == null && this.getPrimitiveField().getAnnotation(OneToOne.class) == null && this.getPrimitiveField().getAnnotation(ManyToMany.class) == null;
    }

    public boolean isExportable() {
        return !this.isBinary();
    }

    public boolean isGeneratedValue() {
        return this.getPrimitiveField().getAnnotation(GeneratedValue.class) != null;
    }

    public Set<DbFieldValue> getAllValues() {
        if (this.type instanceof EnumFieldType) {
            List<?> values = this.type.getValues();
            return values.stream().map(v -> new DbFieldValue(v, this)).collect(Collectors.toSet());
        }
        List findAll = this.schema.getJpaRepository().findAll();
        return findAll.stream().map(o -> new DbObject(o, this.schema).get(this)).collect(Collectors.toSet());
    }

    public String toString() {
        return "DbField [name=" + this.dbName + ", javaName=" + this.javaName + ", type=" + this.type + ", field=" + this.field + ", connectedType=" + this.connectedType + ", primaryKey=" + this.primaryKey + ", nullable=" + this.nullable + ", schema=" + this.schema.getClassName() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.dbName, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DbField other = (DbField)obj;
        return Objects.equals(this.dbName, other.dbName) && this.type == other.type;
    }
}

