/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.dbmapping;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.web.multipart.MultipartFile;
import tech.ailef.snapadmin.external.SnapAdmin;
import tech.ailef.snapadmin.external.annotations.ComputedColumn;
import tech.ailef.snapadmin.external.annotations.DisableCreate;
import tech.ailef.snapadmin.external.annotations.DisableDelete;
import tech.ailef.snapadmin.external.annotations.DisableEdit;
import tech.ailef.snapadmin.external.annotations.DisableExport;
import tech.ailef.snapadmin.external.annotations.HiddenColumn;
import tech.ailef.snapadmin.external.dbmapping.CustomJpaRepository;
import tech.ailef.snapadmin.external.dbmapping.DbObject;
import tech.ailef.snapadmin.external.dbmapping.fields.DbField;
import tech.ailef.snapadmin.external.dto.MappingError;
import tech.ailef.snapadmin.external.exceptions.SnapAdminException;
import tech.ailef.snapadmin.external.exceptions.SnapAdminNotFoundException;
import tech.ailef.snapadmin.external.misc.Utils;

public class DbObjectSchema {
    @JsonIgnore
    private List<DbField> fields = new ArrayList<DbField>();
    @JsonIgnore
    private Map<String, Method> computedColumns = new HashMap<String, Method>();
    private CustomJpaRepository jpaRepository;
    private SnapAdmin snapAdmin;
    @JsonIgnore
    private Class<?> entityClass;
    private String tableName;
    private List<MappingError> errors = new ArrayList<MappingError>();

    public DbObjectSchema(Class<?> klass, SnapAdmin snapAdmin) {
        this.snapAdmin = snapAdmin;
        this.entityClass = klass;
        Table tableAnnotation = klass.getAnnotation(Table.class);
        String tableName = Utils.camelToSnake(this.getJavaClass().getSimpleName());
        if (tableAnnotation != null && tableAnnotation.name() != null && !tableAnnotation.name().isBlank()) {
            tableName = tableAnnotation.name();
        }
        this.tableName = tableName;
        List methods = Arrays.stream(this.entityClass.getMethods()).filter(m -> m.getAnnotation(ComputedColumn.class) != null).collect(Collectors.toList());
        for (Method m2 : methods) {
            if (m2.getParameterCount() > 0) {
                throw new SnapAdminException("@ComputedColumn can only be applied on no-args methods");
            }
            String name = m2.getAnnotation(ComputedColumn.class).name();
            if (name.isBlank()) {
                name = Utils.camelToSnake(m2.getName());
            }
            this.computedColumns.put(name, m2);
        }
    }

    public String getBasePackage() {
        return this.entityClass.getPackageName();
    }

    public SnapAdmin getSnapAdmin() {
        return this.snapAdmin;
    }

    @JsonIgnore
    public Class<?> getJavaClass() {
        return this.entityClass;
    }

    @JsonIgnore
    public String getClassName() {
        return this.entityClass.getName();
    }

    public List<DbField> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public List<MappingError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public DbField getFieldByJavaName(String name) {
        return this.fields.stream().filter(f -> f.getJavaName().equals(name)).findFirst().orElse(null);
    }

    public DbField getFieldByName(String name) {
        return this.fields.stream().filter(f -> f.getName().equals(name)).findFirst().orElse(null);
    }

    public void addField(DbField f) {
        this.fields.add(f);
    }

    public void addError(MappingError error) {
        this.errors.add(error);
    }

    public CustomJpaRepository getJpaRepository() {
        return this.jpaRepository;
    }

    public void setJpaRepository(CustomJpaRepository jpaRepository) {
        this.jpaRepository = jpaRepository;
    }

    public String getTableName() {
        return this.tableName;
    }

    @JsonIgnore
    public List<DbField> getSortedFields() {
        return this.getSortedFields(true);
    }

    public List<DbField> getSortedFields(boolean readOnly) {
        return this.getFields().stream().filter(f -> {
            boolean toMany = f.getPrimitiveField().getAnnotation(OneToMany.class) == null && f.getPrimitiveField().getAnnotation(ManyToMany.class) == null;
            OneToOne oneToOne = f.getPrimitiveField().getAnnotation(OneToOne.class);
            boolean mappedBy = oneToOne != null && !oneToOne.mappedBy().isBlank();
            boolean hidden = f.getPrimitiveField().getAnnotation(HiddenColumn.class) != null;
            return toMany && !mappedBy && (!hidden || !readOnly);
        }).sorted((a, b) -> {
            if (a.isPrimaryKey() && !b.isPrimaryKey()) {
                return -1;
            }
            if (b.isPrimaryKey() && !a.isPrimaryKey()) {
                return 1;
            }
            if (!a.isNullable() && b.isNullable()) {
                return -1;
            }
            if (a.isNullable() && !b.isNullable()) {
                return 1;
            }
            return a.getName().compareTo(b.getName());
        }).collect(Collectors.toList());
    }

    public List<DbField> getRelationshipFields() {
        List<DbField> res = this.getFields().stream().filter(f -> f.getPrimitiveField().getAnnotation(OneToMany.class) != null || f.getPrimitiveField().getAnnotation(ManyToMany.class) != null).filter(f -> this.snapAdmin.isManagedClass(f.getConnectedType())).collect(Collectors.toList());
        return res;
    }

    public List<DbField> getManyToManyOwnedFields() {
        List<DbField> res = this.getFields().stream().filter(f -> {
            ManyToMany anno = f.getPrimitiveField().getAnnotation(ManyToMany.class);
            return anno != null && anno.mappedBy().isBlank();
        }).collect(Collectors.toList());
        return res;
    }

    @JsonIgnore
    public DbField getPrimaryKey() {
        Optional<DbField> pk = this.fields.stream().filter(f -> f.isPrimaryKey()).findFirst();
        if (pk.isPresent()) {
            return pk.get();
        }
        throw new RuntimeException("No primary key defined on " + this.entityClass.getName() + " (table `" + this.tableName + "`)");
    }

    public List<String> getComputedColumnNames() {
        return this.computedColumns.keySet().stream().sorted().toList();
    }

    public Method getComputedColumn(String name) {
        return this.computedColumns.get(name);
    }

    public List<DbField> getFilterableFields() {
        return this.getSortedFields().stream().filter(f -> !f.isBinary() && !f.isPrimaryKey() && f.isFilterable()).toList();
    }

    public boolean isDeleteEnabled() {
        return this.entityClass.getAnnotation(DisableDelete.class) == null;
    }

    public boolean isEditEnabled() {
        return this.entityClass.getAnnotation(DisableEdit.class) == null;
    }

    public boolean isCreateEnabled() {
        return this.entityClass.getAnnotation(DisableCreate.class) == null;
    }

    public boolean isExportEnabled() {
        return this.entityClass.getAnnotation(DisableExport.class) == null;
    }

    public List<DbObject> findAll() {
        List r = this.jpaRepository.findAll();
        return r.stream().map(o -> new DbObject(o, this)).toList();
    }

    public DbObject buildObject(Map<String, String> params, Map<String, MultipartFile> files) {
        try {
            Object instance = this.getJavaClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            DbObject dbObject = new DbObject(instance, this);
            for (String param : params.keySet()) {
                if (param.startsWith("__") || param.equals("_csrf")) continue;
                DbField dbField = this.getFieldByName(param);
                if (dbField == null) {
                    throw new SnapAdminNotFoundException("Cannot find field " + param + " in " + this.getJavaClass().getName());
                }
                String javaFieldName = dbField.getJavaName();
                Method setter = dbObject.findSetter(javaFieldName);
                if (setter == null) {
                    throw new RuntimeException("Cannot find setter for " + javaFieldName);
                }
                Object parsedFieldValue = this.getFieldByName(param).getType().parseValue(params.get(param));
                if (parsedFieldValue != null && this.getFieldByName(param).isSettable()) {
                    setter.invoke(instance, parsedFieldValue);
                }
                if (parsedFieldValue == null || !this.getFieldByName(param).isToOne()) continue;
                dbObject.setRelationship(param, parsedFieldValue);
            }
            for (String fileParam : files.keySet()) {
                if (fileParam.startsWith("__")) continue;
                String javaFieldName = this.getFieldByName(fileParam).getJavaName();
                Method setter = dbObject.findSetter(javaFieldName);
                if (setter == null) {
                    throw new RuntimeException("Cannot find setter for " + fileParam);
                }
                Object parsedFieldValue = this.getFieldByName(fileParam).getType().parseValue(params.get(fileParam));
                if (parsedFieldValue == null || !this.getFieldByName(fileParam).isSettable()) continue;
                setter.invoke(instance, parsedFieldValue);
            }
            return dbObject;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new SnapAdminException(e);
        }
    }

    public String toString() {
        return "DbObjectSchema [fields=" + this.fields + ", className=" + this.entityClass.getName() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DbObjectSchema other = (DbObjectSchema)obj;
        return Objects.equals(this.tableName, other.tableName);
    }
}

