/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.dbmapping;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Objects;
import tech.ailef.snapadmin.external.dbmapping.fields.DbField;

public class DbFieldValue {
    private Object value;
    private DbField field;

    public DbFieldValue(Object value, DbField field) {
        this.value = value;
        this.field = field;
    }

    public Object getValue() {
        if (this.value instanceof OffsetDateTime) {
            return LocalDateTime.from((OffsetDateTime)this.value);
        }
        if (this.value instanceof Instant) {
            Instant i = (Instant)this.value;
            LocalDateTime result = LocalDateTime.ofInstant(i, ZoneId.of("UTC"));
            return result;
        }
        return this.value;
    }

    public String getFormattedValue() {
        if (this.value == null) {
            return null;
        }
        if (this.field.getFormat() == null) {
            return this.value.toString();
        }
        return String.format(this.field.getFormat(), this.value);
    }

    public DbField getField() {
        return this.field;
    }

    @JsonIgnore
    public String getJavaName() {
        return this.field.getPrimitiveField().getName();
    }

    public String toString() {
        return "DbFieldValue [value=" + this.value + ", field=" + this.field + "]";
    }

    public int hashCode() {
        return Objects.hash(this.field, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DbFieldValue other = (DbFieldValue)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.value, other.value);
    }
}

