/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.controller;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.ConstraintViolationException;
import java.security.Principal;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.id.IdentifierGenerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.ui.Model;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import tech.ailef.snapadmin.external.SnapAdmin;
import tech.ailef.snapadmin.external.SnapAdminProperties;
import tech.ailef.snapadmin.external.dbmapping.DbObject;
import tech.ailef.snapadmin.external.dbmapping.DbObjectSchema;
import tech.ailef.snapadmin.external.dbmapping.SnapAdminRepository;
import tech.ailef.snapadmin.external.dbmapping.query.DbQueryResult;
import tech.ailef.snapadmin.external.dto.CompareOperator;
import tech.ailef.snapadmin.external.dto.FacetedSearchRequest;
import tech.ailef.snapadmin.external.dto.LogsSearchRequest;
import tech.ailef.snapadmin.external.dto.PaginatedResult;
import tech.ailef.snapadmin.external.dto.PaginationInfo;
import tech.ailef.snapadmin.external.dto.QueryFilter;
import tech.ailef.snapadmin.external.dto.ValidationErrorsContainer;
import tech.ailef.snapadmin.external.exceptions.InvalidPageException;
import tech.ailef.snapadmin.external.exceptions.SnapAdminException;
import tech.ailef.snapadmin.external.exceptions.SnapAdminNotFoundException;
import tech.ailef.snapadmin.external.misc.Utils;
import tech.ailef.snapadmin.internal.model.ConsoleQuery;
import tech.ailef.snapadmin.internal.model.UserAction;
import tech.ailef.snapadmin.internal.model.UserSetting;
import tech.ailef.snapadmin.internal.service.ConsoleQueryService;
import tech.ailef.snapadmin.internal.service.UserActionService;
import tech.ailef.snapadmin.internal.service.UserSettingsService;

@Controller
@RequestMapping(value={"/${snapadmin.baseUrl}", "/${snapadmin.baseUrl}/"})
public class SnapAdminController {
    private static final Logger logger = LoggerFactory.getLogger(SnapAdminController.class);
    @Autowired
    private SnapAdminProperties properties;
    @Autowired
    private SnapAdminRepository repository;
    @Autowired
    private SnapAdmin snapAdmin;
    @Autowired
    private UserActionService userActionService;
    @Autowired
    private ConsoleQueryService consoleService;
    @Autowired
    private UserSettingsService userSettingsService;

    @GetMapping
    public String index(Model model, @RequestParam(required=false) String query) {
        List<DbObjectSchema> schemas = this.snapAdmin.getSchemas();
        if (query != null && !query.isBlank()) {
            schemas = schemas.stream().filter(s -> s.getClassName().toLowerCase().contains(query.toLowerCase()) || s.getTableName().toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList());
        }
        Map<String, List<DbObjectSchema>> groupedBy = schemas.stream().collect(Collectors.groupingBy(s -> s.getBasePackage()));
        Map<String, Long> counts = schemas.stream().collect(Collectors.toMap(s -> s.getClassName(), s -> this.repository.count((DbObjectSchema)s)));
        model.addAttribute("schemas", groupedBy);
        model.addAttribute("query", (Object)query);
        model.addAttribute("counts", counts);
        model.addAttribute("activePage", (Object)"entities");
        model.addAttribute("title", (Object)"Entities | Index");
        return "snapadmin/home";
    }

    @GetMapping(value={"/model/{className}"})
    public String list(Model model, @PathVariable String className, @RequestParam(required=false) Integer page, @RequestParam(required=false) String query, @RequestParam(required=false) Integer pageSize, @RequestParam(required=false) String sortKey, @RequestParam(required=false) String sortOrder, @RequestParam MultiValueMap<String, String> otherParams, HttpServletRequest request, HttpServletResponse response) {
        if (page == null) {
            page = 1;
        }
        if (pageSize == null) {
            pageSize = 50;
        }
        DbObjectSchema schema = this.snapAdmin.findSchemaByClassName(className);
        Set<QueryFilter> queryFilters = Utils.computeFilters(schema, otherParams);
        if (otherParams.containsKey((Object)"remove_field")) {
            List fields = (List)otherParams.get((Object)"remove_field");
            for (int i = 0; i < fields.size(); ++i) {
                QueryFilter toRemove = new QueryFilter(schema.getFieldByJavaName((String)fields.get(i)), CompareOperator.valueOf(((String)((List)otherParams.get((Object)"remove_op")).get(i)).toUpperCase()), (String)((List)otherParams.get((Object)"remove_value")).get(i));
                queryFilters.removeIf(f -> f.equals(toRemove));
            }
            FacetedSearchRequest filterRequest = new FacetedSearchRequest(queryFilters);
            MultiValueMap<String, String> parameterMap = filterRequest.computeParams();
            LinkedMultiValueMap filteredParams = new LinkedMultiValueMap();
            request.getParameterMap().entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("remove_") && !((String)e.getKey()).startsWith("filter_")).forEach(arg_0 -> SnapAdminController.lambda$list$6((MultiValueMap)filteredParams, arg_0));
            filteredParams.putAll(parameterMap);
            String queryString = Utils.getQueryString((MultiValueMap<String, String>)filteredParams);
            String redirectUrl = request.getServletPath() + queryString;
            return "redirect:" + redirectUrl.trim();
        }
        try {
            PaginatedResult<DbObject> result = null;
            result = query != null || !otherParams.isEmpty() ? this.repository.search(schema, query, page, pageSize, sortKey, sortOrder, queryFilters) : this.repository.findAll(schema, page, pageSize, sortKey, sortOrder);
            model.addAttribute("title", (Object)("Entities | " + schema.getJavaClass().getSimpleName() + " | Index"));
            model.addAttribute("page", result);
            model.addAttribute("schema", (Object)schema);
            model.addAttribute("activePage", (Object)"entities");
            model.addAttribute("sortKey", (Object)sortKey);
            model.addAttribute("query", (Object)query);
            model.addAttribute("sortOrder", (Object)sortOrder);
            model.addAttribute("activeFilters", queryFilters);
            return "snapadmin/model/list";
        }
        catch (InvalidPageException e2) {
            return "redirect:/" + this.properties.getBaseUrl() + "/model/" + className;
        }
        catch (SnapAdminException e3) {
            model.addAttribute("error", (Object)e3.getMessage());
            model.addAttribute("errorTitle", (Object)"Invalid request");
            model.addAttribute("schema", (Object)schema);
            model.addAttribute("activePage", (Object)"entities");
            model.addAttribute("sortKey", (Object)sortKey);
            model.addAttribute("query", (Object)query);
            model.addAttribute("sortOrder", (Object)sortOrder);
            model.addAttribute("activeFilters", queryFilters);
            return "snapadmin/model/list";
        }
    }

    @GetMapping(value={"/model/{className}/schema"})
    public String schema(Model model, @PathVariable String className) {
        DbObjectSchema schema = this.snapAdmin.findSchemaByClassName(className);
        model.addAttribute("activePage", (Object)"entities");
        model.addAttribute("schema", (Object)schema);
        return "snapadmin/model/schema";
    }

    @GetMapping(value={"/model/{className}/show/{id}"})
    public String show(Model model, @PathVariable String className, @PathVariable String id) {
        DbObjectSchema schema = this.snapAdmin.findSchemaByClassName(className);
        Object pkValue = schema.getPrimaryKey().getType().parseValue(id);
        DbObject object = this.repository.findById(schema, pkValue).orElseThrow(() -> new SnapAdminNotFoundException(schema.getJavaClass().getSimpleName() + " with ID " + id + " not found."));
        model.addAttribute("title", (Object)("Entities | " + schema.getJavaClass().getSimpleName() + " | " + object.getDisplayName()));
        model.addAttribute("object", (Object)object);
        model.addAttribute("activePage", (Object)"entities");
        model.addAttribute("schema", (Object)schema);
        return "snapadmin/model/show";
    }

    @GetMapping(value={"/model/{className}/create"})
    public String create(Model model, @PathVariable String className, RedirectAttributes attr) {
        DbObjectSchema schema = this.snapAdmin.findSchemaByClassName(className);
        if (!schema.isCreateEnabled()) {
            attr.addFlashAttribute("errorTitle", (Object)"Unauthorized");
            attr.addFlashAttribute("error", (Object)("CREATE operations have been disabled on this type (" + schema.getJavaClass().getSimpleName() + ")."));
            return "redirect:/" + this.properties.getBaseUrl() + "/model/" + className;
        }
        model.addAttribute("className", (Object)className);
        model.addAttribute("schema", (Object)schema);
        model.addAttribute("title", (Object)("Entities | " + schema.getJavaClass().getSimpleName() + " | Create"));
        model.addAttribute("activePage", (Object)"entities");
        model.addAttribute("create", (Object)true);
        return "snapadmin/model/create";
    }

    @GetMapping(value={"/model/{className}/edit/{id}"})
    public String edit(Model model, @PathVariable String className, @PathVariable String id, RedirectAttributes attr) {
        DbObjectSchema schema = this.snapAdmin.findSchemaByClassName(className);
        Object pkValue = schema.getPrimaryKey().getType().parseValue(id);
        if (!schema.isEditEnabled()) {
            attr.addFlashAttribute("errorTitle", (Object)"Unauthorized");
            attr.addFlashAttribute("error", (Object)("EDIT operations have been disabled on this type (" + schema.getJavaClass().getSimpleName() + ")."));
            return "redirect:/" + this.properties.getBaseUrl() + "/model/" + className;
        }
        DbObject object = this.repository.findById(schema, pkValue).orElseThrow(() -> new SnapAdminNotFoundException("Object " + className + " with id " + id + " not found"));
        model.addAttribute("title", (Object)("Entities | " + schema.getJavaClass().getSimpleName() + " | Edit | " + object.getDisplayName()));
        model.addAttribute("className", (Object)className);
        model.addAttribute("object", (Object)object);
        model.addAttribute("schema", (Object)schema);
        model.addAttribute("activePage", (Object)"entities");
        model.addAttribute("create", (Object)false);
        return "snapadmin/model/create";
    }

    @PostMapping(value={"/model/{className}/delete/{id}"})
    public String delete(@PathVariable String className, @PathVariable String id, RedirectAttributes attr, Principal principal) {
        String authUser;
        DbObjectSchema schema = this.snapAdmin.findSchemaByClassName(className);
        String string = authUser = principal != null ? principal.getName() : null;
        if (!schema.isDeleteEnabled()) {
            attr.addFlashAttribute("errorTitle", (Object)"Unable to DELETE row");
            attr.addFlashAttribute("error", (Object)"DELETE operations have been disabled on this table.");
            return "redirect:/" + this.properties.getBaseUrl() + "/model/" + className;
        }
        try {
            this.repository.delete(schema, id);
        }
        catch (DataIntegrityViolationException e) {
            attr.addFlashAttribute("errorTitle", (Object)"Unable to DELETE row");
            attr.addFlashAttribute("error", (Object)e.getMessage());
            return "redirect:/" + this.properties.getBaseUrl() + "/model/" + className;
        }
        this.saveAction(new UserAction(schema.getTableName(), id, "DELETE", schema.getClassName(), authUser));
        attr.addFlashAttribute("message", (Object)("Deleted " + schema.getJavaClass().getSimpleName() + " with " + schema.getPrimaryKey().getName() + "=" + id));
        return "redirect:/" + this.properties.getBaseUrl() + "/model/" + className;
    }

    @PostMapping(value={"/model/{className}/delete"})
    public String delete(@PathVariable String className, @RequestParam String[] ids, RedirectAttributes attr, Principal principal) {
        String authUser;
        DbObjectSchema schema = this.snapAdmin.findSchemaByClassName(className);
        String string = authUser = principal != null ? principal.getName() : null;
        if (!schema.isDeleteEnabled()) {
            attr.addFlashAttribute("errorTitle", (Object)"Unable to DELETE rows");
            attr.addFlashAttribute("error", (Object)"DELETE operations have been disabled on this table.");
            return "redirect:/" + this.properties.getBaseUrl() + "/model/" + className;
        }
        int countDeleted = 0;
        for (String id : ids) {
            try {
                this.repository.delete(schema, id);
                ++countDeleted;
            }
            catch (DataIntegrityViolationException e) {
                attr.addFlashAttribute("error", (Object)e.getMessage());
            }
        }
        if (countDeleted > 0) {
            attr.addFlashAttribute("message", (Object)("Deleted " + countDeleted + " of " + ids.length + " items"));
        }
        for (String id : ids) {
            this.saveAction(new UserAction(schema.getTableName(), id, "DELETE", schema.getClassName(), authUser));
        }
        return "redirect:/" + this.properties.getBaseUrl() + "/model/" + className;
    }

    @PostMapping(value={"/model/{className}/create"})
    public String store(@PathVariable String className, @RequestParam MultiValueMap<String, String> formParams, @RequestParam Map<String, MultipartFile> files, RedirectAttributes attr, Principal principal) {
        String authUser = principal != null ? principal.getName() : null;
        HashMap<String, String> params = new HashMap<String, String>();
        for (Object param : formParams.keySet()) {
            if (((String)param).endsWith("[]")) continue;
            params.put((String)param, (String)formParams.getFirst(param));
        }
        HashMap<String, List<String>> multiValuedParams = new HashMap<String, List<String>>();
        for (String param : formParams.keySet()) {
            if (!param.endsWith("[]")) continue;
            List list = (List)formParams.get((Object)param);
            if (list.size() == 1) {
                multiValuedParams.put(param, new ArrayList());
                continue;
            }
            list.removeIf(f -> f.isBlank());
            multiValuedParams.put(param, list);
        }
        String c = (String)params.get("__snapadmin_create");
        if (c == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing required param __snapadmin_create");
        }
        boolean create = Boolean.parseBoolean(c);
        DbObjectSchema schema = this.snapAdmin.findSchemaByClassName(className);
        if (!schema.isCreateEnabled() && create) {
            attr.addFlashAttribute("errorTitle", (Object)"Unauthorized");
            attr.addFlashAttribute("error", (Object)("CREATE operations have been disabled on this type (" + schema.getJavaClass().getSimpleName() + ")."));
            return "redirect:/" + this.properties.getBaseUrl() + "/model/" + className;
        }
        String pkValue = (String)params.get(schema.getPrimaryKey().getName());
        if (pkValue == null || pkValue.isBlank()) {
            pkValue = null;
        }
        try {
            if (pkValue == null) {
                Object newPrimaryKey = this.repository.create(schema, params, files, pkValue);
                this.repository.attachManyToMany(schema, newPrimaryKey, multiValuedParams);
                pkValue = newPrimaryKey.toString();
                attr.addFlashAttribute("message", (Object)"Item created successfully.");
                this.saveAction(new UserAction(schema.getTableName(), pkValue, "CREATE", schema.getClassName(), authUser));
            } else {
                Object parsedPkValue = schema.getPrimaryKey().getType().parseValue(pkValue);
                Optional<DbObject> object = this.repository.findById(schema, parsedPkValue);
                if (!object.isEmpty()) {
                    if (create) {
                        attr.addFlashAttribute("errorTitle", (Object)"Unable to create item");
                        attr.addFlashAttribute("error", (Object)("Item with id " + object.get().getPrimaryKeyValue() + " already exists."));
                        attr.addFlashAttribute("params", params);
                    } else {
                        this.repository.update(schema, params, files);
                        this.repository.attachManyToMany(schema, parsedPkValue, multiValuedParams);
                        attr.addFlashAttribute("message", (Object)"Item saved successfully.");
                        this.saveAction(new UserAction(schema.getTableName(), parsedPkValue.toString(), "EDIT", schema.getClassName(), authUser));
                    }
                } else {
                    Object newPrimaryKey = this.repository.create(schema, params, files, pkValue);
                    this.repository.attachManyToMany(schema, newPrimaryKey, multiValuedParams);
                    attr.addFlashAttribute("message", (Object)"Item created successfully");
                    this.saveAction(new UserAction(schema.getTableName(), pkValue, "CREATE", schema.getClassName(), authUser));
                }
            }
        }
        catch (IdentifierGenerationException | DataIntegrityViolationException | UncategorizedSQLException e) {
            attr.addFlashAttribute("errorTitle", (Object)"Error");
            attr.addFlashAttribute("error", (Object)e.getMessage());
            attr.addFlashAttribute("params", params);
        }
        catch (ConstraintViolationException e) {
            attr.addFlashAttribute("errorTitle", (Object)"Validation error");
            attr.addFlashAttribute("error", (Object)"See below for details");
            attr.addFlashAttribute("validationErrors", (Object)new ValidationErrorsContainer(e));
            attr.addFlashAttribute("params", params);
        }
        catch (SnapAdminException e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            logger.error(Arrays.toString(cause.getStackTrace()));
            attr.addFlashAttribute("errorTitle", (Object)"Error");
            attr.addFlashAttribute("error", (Object)e.getMessage());
            attr.addFlashAttribute("params", params);
        }
        catch (TransactionSystemException e) {
            if (e.getRootCause() instanceof ConstraintViolationException) {
                ConstraintViolationException ee = (ConstraintViolationException)e.getRootCause();
                attr.addFlashAttribute("errorTitle", (Object)"Validation error");
                attr.addFlashAttribute("error", (Object)"See below for details");
                attr.addFlashAttribute("validationErrors", (Object)new ValidationErrorsContainer(ee));
                attr.addFlashAttribute("params", params);
            }
            throw new RuntimeException(e);
        }
        if (attr.getFlashAttributes().containsKey("error")) {
            if (create) {
                return "redirect:/" + this.properties.getBaseUrl() + "/model/" + schema.getClassName() + "/create";
            }
            return "redirect:/" + this.properties.getBaseUrl() + "/model/" + schema.getClassName() + "/edit/" + pkValue;
        }
        return "redirect:/" + this.properties.getBaseUrl() + "/model/" + schema.getClassName() + "/show/" + pkValue;
    }

    @GetMapping(value={"/logs"})
    public String logs(Model model, LogsSearchRequest searchRequest) {
        model.addAttribute("activePage", (Object)"logs");
        model.addAttribute("page", this.userActionService.findActions(searchRequest));
        model.addAttribute("title", (Object)"Action logs");
        model.addAttribute("schemas", this.snapAdmin.getSchemas());
        model.addAttribute("searchRequest", (Object)searchRequest);
        return "snapadmin/logs";
    }

    @GetMapping(value={"/settings"})
    public String settings(Model model) {
        model.addAttribute("title", (Object)"Settings");
        model.addAttribute("activePage", (Object)"settings");
        return "snapadmin/settings/settings";
    }

    @GetMapping(value={"/help"})
    public String help(Model model) {
        model.addAttribute("title", (Object)"Help");
        model.addAttribute("activePage", (Object)"help");
        return "snapadmin/help";
    }

    @GetMapping(value={"/console/new"})
    public String consoleNew(Model model) {
        if (!this.properties.isSqlConsoleEnabled()) {
            throw new SnapAdminException("SQL console not enabled");
        }
        ConsoleQuery q = new ConsoleQuery();
        this.consoleService.save(q);
        return "redirect:/" + this.properties.getBaseUrl() + "/console/run/" + q.getId();
    }

    @GetMapping(value={"/console"})
    public String console() {
        if (!this.properties.isSqlConsoleEnabled()) {
            throw new SnapAdminException("SQL console not enabled");
        }
        List<ConsoleQuery> tabs = this.consoleService.findAll();
        if (tabs.isEmpty()) {
            ConsoleQuery q = new ConsoleQuery();
            int randomIndex = new Random().nextInt(0, this.snapAdmin.getSchemas().size());
            String randomTable = this.snapAdmin.getSchemas().get(randomIndex).getTableName();
            q.setSql("-- It's recommended to always include a LIMIT clause in your query\n-- Although the SQL Console supports pagination, it retrieves the entire ResultSet\n\n-- SELECT * FROM " + randomTable + " LIMIT 1000;\n");
            this.consoleService.save(q);
            return "redirect:/" + this.properties.getBaseUrl() + "/console/run/" + q.getId();
        }
        return "redirect:/" + this.properties.getBaseUrl() + "/console/run/" + tabs.get(0).getId();
    }

    @PostMapping(value={"/console/delete/{queryId}"})
    public String consoleDelete(@PathVariable String queryId, Model model) {
        if (!this.properties.isSqlConsoleEnabled()) {
            throw new SnapAdminException("SQL console not enabled");
        }
        this.consoleService.delete(queryId);
        return "redirect:/" + this.properties.getBaseUrl() + "/console";
    }

    @GetMapping(value={"/console/run/{queryId}"})
    public String consoleRun(Model model, @RequestParam(required=false) String query, @RequestParam(required=false) String queryTitle, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer pageSize, @PathVariable String queryId) {
        if (page == null || page <= 0) {
            page = 1;
        }
        if (pageSize == null) {
            pageSize = 50;
        }
        long startTime = System.currentTimeMillis();
        if (!this.properties.isSqlConsoleEnabled()) {
            throw new SnapAdminException("SQL console not enabled");
        }
        ConsoleQuery activeQuery = this.consoleService.findById(queryId).orElseThrow(() -> new SnapAdminNotFoundException("Query with ID " + queryId + " not found."));
        if (query != null && !query.isBlank()) {
            activeQuery.setSql(query);
        }
        if (queryTitle != null && !queryTitle.isBlank()) {
            activeQuery.setTitle(queryTitle);
        }
        activeQuery.setUpdatedAt(LocalDateTime.now());
        this.consoleService.save(activeQuery);
        model.addAttribute("activePage", (Object)"console");
        model.addAttribute("activeQuery", (Object)activeQuery);
        List<ConsoleQuery> tabs = this.consoleService.findAll();
        model.addAttribute("tabs", tabs);
        DbQueryResult results = this.repository.executeQuery(activeQuery.getSql());
        if (!results.isEmpty()) {
            int maxPage = (int)Math.ceil((double)results.size() / (double)pageSize.intValue());
            PaginationInfo pagination = new PaginationInfo(page, maxPage, pageSize, results.size(), null, null);
            int startOffset = (page - 1) * pageSize;
            int endOffset = page * pageSize;
            endOffset = Math.min(results.size(), endOffset);
            results.crop(startOffset, endOffset);
            model.addAttribute("pagination", (Object)pagination);
            model.addAttribute("results", (Object)results);
        } else {
            PaginationInfo pagination = new PaginationInfo(page, 0, pageSize, results.size(), null, null);
            model.addAttribute("pagination", (Object)pagination);
        }
        model.addAttribute("title", (Object)("SQL Console | " + activeQuery.getTitle()));
        double elapsedTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        model.addAttribute("elapsedTime", (Object)new DecimalFormat("0.0#").format(elapsedTime));
        return "snapadmin/console";
    }

    @GetMapping(value={"/settings/appearance"})
    public String settingsAppearance(Model model) {
        model.addAttribute("activePage", (Object)"settings");
        return "snapadmin/settings/appearance";
    }

    @GetMapping(value={"/forbidden"})
    public String forbidden(Model model) {
        model.addAttribute("error", (Object)"Forbidden");
        model.addAttribute("status", (Object)"403");
        model.addAttribute("message", (Object)"You don't have the privileges to perform this action");
        return "snapadmin/other/error";
    }

    @PostMapping(value={"/settings"})
    public String settings(@RequestParam Map<String, String> params, Model model) {
        String next = params.getOrDefault("next", "settings/settings");
        for (String paramName : params.keySet()) {
            if (paramName.equals("next")) continue;
            this.userSettingsService.save(new UserSetting(paramName, params.get(paramName)));
        }
        model.addAttribute("activePage", (Object)"settings");
        return next;
    }

    private UserAction saveAction(UserAction action) {
        return this.userActionService.save(action);
    }

    private static /* synthetic */ void lambda$list$6(MultiValueMap filteredParams, Map.Entry e) {
        filteredParams.putIfAbsent((Object)((String)e.getKey()), new ArrayList());
        for (String v : (String[])e.getValue()) {
            if (((List)filteredParams.get(e.getKey())).isEmpty()) {
                ((List)filteredParams.get(e.getKey())).add(v);
                continue;
            }
            ((List)filteredParams.get(e.getKey())).set(0, v);
        }
    }
}

