/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import tech.ailef.snapadmin.external.SnapAdmin;
import tech.ailef.snapadmin.external.dbmapping.DbFieldValue;
import tech.ailef.snapadmin.external.dbmapping.DbObject;
import tech.ailef.snapadmin.external.dbmapping.DbObjectSchema;
import tech.ailef.snapadmin.external.dbmapping.SnapAdminRepository;
import tech.ailef.snapadmin.external.dbmapping.fields.DbField;
import tech.ailef.snapadmin.external.dbmapping.query.DbQueryResult;
import tech.ailef.snapadmin.external.dbmapping.query.DbQueryResultRow;
import tech.ailef.snapadmin.external.dto.DataExportFormat;
import tech.ailef.snapadmin.external.dto.QueryFilter;
import tech.ailef.snapadmin.external.exceptions.SnapAdminException;
import tech.ailef.snapadmin.external.exceptions.SnapAdminNotFoundException;
import tech.ailef.snapadmin.external.misc.Utils;
import tech.ailef.snapadmin.internal.model.ConsoleQuery;
import tech.ailef.snapadmin.internal.repository.ConsoleQueryRepository;

@Controller
@RequestMapping(value={"/${snapadmin.baseUrl}/", "/${snapadmin.baseUrl}"})
public class DataExportController {
    private static final Logger logger = LoggerFactory.getLogger(DataExportFormat.class);
    @Autowired
    private SnapAdmin snapAdmin;
    @Autowired
    private SnapAdminRepository repository;
    @Autowired
    private ConsoleQueryRepository queryRepository;
    @Autowired
    private ObjectMapper mapper;

    @GetMapping(value={"/console/export/{queryId}"})
    public ResponseEntity<byte[]> export(@PathVariable String queryId, @RequestParam String format, @RequestParam MultiValueMap<String, String> otherParams) {
        ConsoleQuery query = (ConsoleQuery)this.queryRepository.findById(queryId).orElseThrow(() -> new SnapAdminNotFoundException("Query not found: " + queryId));
        DataExportFormat exportFormat = null;
        try {
            exportFormat = DataExportFormat.valueOf(format.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new SnapAdminException("Unsupported export format: " + format);
        }
        List fieldsToInclude = (List)otherParams.getOrDefault((Object)"fields[]", new ArrayList());
        DbQueryResult results = this.repository.executeQuery(query.getSql());
        switch (exportFormat) {
            case CSV: {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"export_" + query.getTitle().replaceAll("[^a-zA-Z0-9.-]", "_") + ".csv\""})).body((Object)this.toCsvQuery(results, fieldsToInclude).getBytes());
            }
            case XLSX: {
                String sheetName = query.getTitle();
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"export_" + query.getTitle().replaceAll("[^a-zA-Z0-9.-]", "_") + ".xlsx\""})).body((Object)this.toXlsxQuery(sheetName, results, fieldsToInclude));
            }
            case JSONL: {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"export_" + query.getTitle().replaceAll("[^a-zA-Z0-9.-]", "_") + ".jsonl\""})).body((Object)this.toJsonlQuery(results, fieldsToInclude).getBytes());
            }
        }
        throw new SnapAdminException("Invalid DataExportFormat");
    }

    @GetMapping(value={"/export/{className}"})
    @ResponseBody
    public ResponseEntity<byte[]> export(@PathVariable String className, @RequestParam(required=false) String query, @RequestParam String format, @RequestParam(required=false) Boolean raw, @RequestParam MultiValueMap<String, String> otherParams) {
        DbObjectSchema schema;
        if (raw == null) {
            raw = false;
        }
        if (!(schema = this.snapAdmin.findSchemaByClassName(className)).isExportEnabled()) {
            throw new SnapAdminException("Export is not enabled for this table: " + schema.getTableName());
        }
        List fieldsToInclude = (List)otherParams.getOrDefault((Object)"fields[]", new ArrayList());
        DataExportFormat exportFormat = null;
        try {
            exportFormat = DataExportFormat.valueOf(format.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new SnapAdminException("Unsupported export format: " + format);
        }
        Set<QueryFilter> queryFilters = Utils.computeFilters(schema, otherParams);
        List<DbObject> results = this.repository.search(schema, query, queryFilters);
        switch (exportFormat) {
            case CSV: {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"export_" + schema.getJavaClass().getSimpleName() + ".csv\""})).body((Object)this.toCsv(results, fieldsToInclude, raw).getBytes());
            }
            case XLSX: {
                String sheetName = schema.getJavaClass().getSimpleName();
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"export_" + schema.getJavaClass().getSimpleName() + ".xlsx\""})).body((Object)this.toXlsx(sheetName, results, fieldsToInclude, raw));
            }
            case JSONL: {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"export_" + schema.getJavaClass().getSimpleName() + ".jsonl\""})).body((Object)this.toJsonl(results, fieldsToInclude, raw).getBytes());
            }
        }
        throw new SnapAdminException("Invalid DataExportFormat");
    }

    private byte[] toXlsx(String sheetName, List<DbObject> items, List<String> fields, boolean raw) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet(sheetName);
        CellStyle headerStyle = workbook.createCellStyle();
        Font headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerStyle.setFont(headerFont);
        int rowIndex = 0;
        Row headerRow = sheet.createRow(rowIndex++);
        for (int i = 0; i < fields.size(); ++i) {
            Cell headerCell = headerRow.createCell(i);
            headerCell.setCellValue(fields.get(i));
            headerCell.setCellStyle(headerStyle);
        }
        for (DbObject item : items) {
            Row row = sheet.createRow(rowIndex++);
            int cellIndex = 0;
            List<String> record = this.getRecord(item, fields, raw);
            for (String value : record) {
                Cell cell = row.createCell(cellIndex++);
                cell.setCellValue(value);
            }
        }
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)fos);
            fos.close();
            workbook.close();
        }
        catch (IOException e) {
            throw new SnapAdminException("Error during serialization for XLSX workbook", e);
        }
        return fos.toByteArray();
    }

    private byte[] toXlsxQuery(String sheetName, DbQueryResult result, List<String> fields) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet(sheetName);
        CellStyle headerStyle = workbook.createCellStyle();
        Font headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerStyle.setFont(headerFont);
        int rowIndex = 0;
        Row headerRow = sheet.createRow(rowIndex++);
        for (int i = 0; i < fields.size(); ++i) {
            Cell headerCell = headerRow.createCell(i);
            headerCell.setCellValue(fields.get(i));
            headerCell.setCellStyle(headerStyle);
        }
        for (DbQueryResultRow item : result.getRows()) {
            Row row = sheet.createRow(rowIndex++);
            int cellIndex = 0;
            List<String> record = this.getRecord(item, fields);
            for (String value : record) {
                Cell cell = row.createCell(cellIndex++);
                cell.setCellValue(value);
            }
        }
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)fos);
            fos.close();
            workbook.close();
        }
        catch (IOException e) {
            throw new SnapAdminException("Error during serialization for XLSX workbook", e);
        }
        return fos.toByteArray();
    }

    private String toJsonl(List<DbObject> items, List<String> fields, boolean raw) {
        if (items.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (DbObject item : items) {
            Map<String, Object> map = item.toMap(fields, raw);
            try {
                String json = this.mapper.writeValueAsString(map);
                sb.append(json);
            }
            catch (JsonProcessingException e) {
                throw new SnapAdminException(e);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private String toJsonlQuery(DbQueryResult result, List<String> fields) {
        if (result.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (DbQueryResultRow item : result.getRows()) {
            Map<String, Object> map = item.toMap(fields);
            try {
                String json = this.mapper.writeValueAsString(map);
                sb.append(json);
            }
            catch (JsonProcessingException e) {
                throw new SnapAdminException(e);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private String toCsv(List<DbObject> items, List<String> fields, boolean raw) {
        String string;
        if (items.isEmpty()) {
            return "";
        }
        StringWriter sw = new StringWriter();
        CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setHeader((String[])fields.toArray(String[]::new)).build();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, csvFormat);
        try {
            for (DbObject item : items) {
                printer.printRecord(this.getRecord(item, fields, raw));
            }
            string = sw.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    printer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SnapAdminException("Error during creation of CSV file", e);
            }
        }
        printer.close();
        return string;
    }

    private String toCsvQuery(DbQueryResult result, List<String> fields) {
        String string;
        if (result.isEmpty()) {
            return "";
        }
        StringWriter sw = new StringWriter();
        CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setHeader((String[])fields.toArray(String[]::new)).build();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, csvFormat);
        try {
            for (DbQueryResultRow item : result.getRows()) {
                printer.printRecord(this.getRecord(item, fields));
            }
            string = sw.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    printer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SnapAdminException("Error during creation of CSV file", e);
            }
        }
        printer.close();
        return string;
    }

    private List<String> getRecord(DbQueryResultRow row, List<String> fields) {
        ArrayList<String> record = new ArrayList<String>();
        for (String field : fields) {
            Object value = row.getFieldByName(field);
            record.add(value == null ? null : value.toString());
        }
        return record;
    }

    private List<String> getRecord(DbObject item, List<String> fields, boolean raw) {
        ArrayList<String> record = new ArrayList<String>();
        Set dbFields = item.getSchema().getSortedFields().stream().map(f -> f.getName()).collect(Collectors.toSet());
        HashSet<String> computedFields = new HashSet<String>(item.getSchema().getComputedColumnNames());
        for (String field : fields) {
            if (dbFields.contains(field)) {
                DbField dbField = item.getSchema().getFieldByName(field);
                if (dbField.isForeignKey()) {
                    DbObject linkedItem = item.traverse(dbField);
                    if (linkedItem == null) {
                        record.add("");
                        continue;
                    }
                    if (raw) {
                        record.add(linkedItem.getPrimaryKeyValue().toString());
                        continue;
                    }
                    record.add(linkedItem.getPrimaryKeyValue() + " (" + linkedItem.getDisplayName() + ")");
                    continue;
                }
                if (raw) {
                    DbFieldValue fieldValue = item.get(dbField);
                    if (fieldValue.getValue() == null) {
                        record.add("");
                        continue;
                    }
                    record.add(fieldValue.getValue().toString());
                    continue;
                }
                record.add(item.get(dbField).getFormattedValue());
                continue;
            }
            if (computedFields.contains(field)) {
                Object computedValue = item.compute(field);
                record.add(computedValue.toString());
                continue;
            }
            logger.info("Missing field `" + field + "` requested for export");
        }
        return record;
    }
}

