/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Transcript
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Transcript> {
    private static final SdkField<String> TRANSCRIPT_FILE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TranscriptFileUri").getter(Transcript.getter(Transcript::transcriptFileUri)).setter(Transcript.setter(Builder::transcriptFileUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptFileUri").build()}).build();
    private static final SdkField<String> REDACTED_TRANSCRIPT_FILE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedactedTranscriptFileUri").getter(Transcript.getter(Transcript::redactedTranscriptFileUri)).setter(Transcript.setter(Builder::redactedTranscriptFileUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedactedTranscriptFileUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FILE_URI_FIELD, REDACTED_TRANSCRIPT_FILE_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Transcript.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String transcriptFileUri;
    private final String redactedTranscriptFileUri;

    private Transcript(BuilderImpl builder) {
        this.transcriptFileUri = builder.transcriptFileUri;
        this.redactedTranscriptFileUri = builder.redactedTranscriptFileUri;
    }

    public final String transcriptFileUri() {
        return this.transcriptFileUri;
    }

    public final String redactedTranscriptFileUri() {
        return this.redactedTranscriptFileUri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptFileUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.redactedTranscriptFileUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transcript)) {
            return false;
        }
        Transcript other = (Transcript)obj;
        return Objects.equals(this.transcriptFileUri(), other.transcriptFileUri()) && Objects.equals(this.redactedTranscriptFileUri(), other.redactedTranscriptFileUri());
    }

    public final String toString() {
        return ToString.builder((String)"Transcript").add("TranscriptFileUri", (Object)this.transcriptFileUri()).add("RedactedTranscriptFileUri", (Object)this.redactedTranscriptFileUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TranscriptFileUri": {
                return Optional.ofNullable(clazz.cast(this.transcriptFileUri()));
            }
            case "RedactedTranscriptFileUri": {
                return Optional.ofNullable(clazz.cast(this.redactedTranscriptFileUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TranscriptFileUri", TRANSCRIPT_FILE_URI_FIELD);
        map.put("RedactedTranscriptFileUri", REDACTED_TRANSCRIPT_FILE_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Transcript, T> g) {
        return obj -> g.apply((Transcript)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transcriptFileUri;
        private String redactedTranscriptFileUri;

        private BuilderImpl() {
        }

        private BuilderImpl(Transcript model) {
            this.transcriptFileUri(model.transcriptFileUri);
            this.redactedTranscriptFileUri(model.redactedTranscriptFileUri);
        }

        public final String getTranscriptFileUri() {
            return this.transcriptFileUri;
        }

        public final void setTranscriptFileUri(String transcriptFileUri) {
            this.transcriptFileUri = transcriptFileUri;
        }

        @Override
        public final Builder transcriptFileUri(String transcriptFileUri) {
            this.transcriptFileUri = transcriptFileUri;
            return this;
        }

        public final String getRedactedTranscriptFileUri() {
            return this.redactedTranscriptFileUri;
        }

        public final void setRedactedTranscriptFileUri(String redactedTranscriptFileUri) {
            this.redactedTranscriptFileUri = redactedTranscriptFileUri;
        }

        @Override
        public final Builder redactedTranscriptFileUri(String redactedTranscriptFileUri) {
            this.redactedTranscriptFileUri = redactedTranscriptFileUri;
            return this;
        }

        public Transcript build() {
            return new Transcript(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Transcript> {
        public Builder transcriptFileUri(String var1);

        public Builder redactedTranscriptFileUri(String var1);
    }
}

