/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.MedicalScribeNoteTemplate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClinicalNoteGenerationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClinicalNoteGenerationSettings> {
    private static final SdkField<String> NOTE_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NoteTemplate").getter(ClinicalNoteGenerationSettings.getter(ClinicalNoteGenerationSettings::noteTemplateAsString)).setter(ClinicalNoteGenerationSettings.setter(Builder::noteTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoteTemplate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTE_TEMPLATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClinicalNoteGenerationSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String noteTemplate;

    private ClinicalNoteGenerationSettings(BuilderImpl builder) {
        this.noteTemplate = builder.noteTemplate;
    }

    public final MedicalScribeNoteTemplate noteTemplate() {
        return MedicalScribeNoteTemplate.fromValue(this.noteTemplate);
    }

    public final String noteTemplateAsString() {
        return this.noteTemplate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.noteTemplateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClinicalNoteGenerationSettings)) {
            return false;
        }
        ClinicalNoteGenerationSettings other = (ClinicalNoteGenerationSettings)obj;
        return Objects.equals(this.noteTemplateAsString(), other.noteTemplateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ClinicalNoteGenerationSettings").add("NoteTemplate", (Object)this.noteTemplateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NoteTemplate": {
                return Optional.ofNullable(clazz.cast(this.noteTemplateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("NoteTemplate", NOTE_TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClinicalNoteGenerationSettings, T> g) {
        return obj -> g.apply((ClinicalNoteGenerationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String noteTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(ClinicalNoteGenerationSettings model) {
            this.noteTemplate(model.noteTemplate);
        }

        public final String getNoteTemplate() {
            return this.noteTemplate;
        }

        public final void setNoteTemplate(String noteTemplate) {
            this.noteTemplate = noteTemplate;
        }

        @Override
        public final Builder noteTemplate(String noteTemplate) {
            this.noteTemplate = noteTemplate;
            return this;
        }

        @Override
        public final Builder noteTemplate(MedicalScribeNoteTemplate noteTemplate) {
            this.noteTemplate(noteTemplate == null ? null : noteTemplate.toString());
            return this;
        }

        public ClinicalNoteGenerationSettings build() {
            return new ClinicalNoteGenerationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClinicalNoteGenerationSettings> {
        public Builder noteTemplate(String var1);

        public Builder noteTemplate(MedicalScribeNoteTemplate var1);
    }
}

