/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.CodeSigningConfig;
import software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse;

public class ListCodeSigningConfigsIterable
implements SdkIterable<ListCodeSigningConfigsResponse> {
    private final LambdaClient client;
    private final ListCodeSigningConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCodeSigningConfigsIterable(LambdaClient client, ListCodeSigningConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCodeSigningConfigsResponseFetcher();
    }

    public Iterator<ListCodeSigningConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CodeSigningConfig> codeSigningConfigs() {
        Function<ListCodeSigningConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.codeSigningConfigs() != null) {
                return response.codeSigningConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCodeSigningConfigsResponseFetcher
    implements SyncPageFetcher<ListCodeSigningConfigsResponse> {
        private ListCodeSigningConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListCodeSigningConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListCodeSigningConfigsResponse nextPage(ListCodeSigningConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListCodeSigningConfigsIterable.this.client.listCodeSigningConfigs(ListCodeSigningConfigsIterable.this.firstRequest);
            }
            return ListCodeSigningConfigsIterable.this.client.listCodeSigningConfigs((ListCodeSigningConfigsRequest)((Object)ListCodeSigningConfigsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

