/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ConnectionOptionsCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.SelectedFieldsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEntityRecordsRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetEntityRecordsRequest> {
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(GetEntityRecordsRequest.getter(GetEntityRecordsRequest::connectionName)).setter(GetEntityRecordsRequest.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(GetEntityRecordsRequest.getter(GetEntityRecordsRequest::catalogId)).setter(GetEntityRecordsRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityName").getter(GetEntityRecordsRequest.getter(GetEntityRecordsRequest::entityName)).setter(GetEntityRecordsRequest.setter(Builder::entityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetEntityRecordsRequest.getter(GetEntityRecordsRequest::nextToken)).setter(GetEntityRecordsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> DATA_STORE_API_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataStoreApiVersion").getter(GetEntityRecordsRequest.getter(GetEntityRecordsRequest::dataStoreApiVersion)).setter(GetEntityRecordsRequest.setter(Builder::dataStoreApiVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStoreApiVersion").build()}).build();
    private static final SdkField<Map<String, String>> CONNECTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ConnectionOptions").getter(GetEntityRecordsRequest.getter(GetEntityRecordsRequest::connectionOptions)).setter(GetEntityRecordsRequest.setter(Builder::connectionOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> FILTER_PREDICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterPredicate").getter(GetEntityRecordsRequest.getter(GetEntityRecordsRequest::filterPredicate)).setter(GetEntityRecordsRequest.setter(Builder::filterPredicate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterPredicate").build()}).build();
    private static final SdkField<Long> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Limit").getter(GetEntityRecordsRequest.getter(GetEntityRecordsRequest::limit)).setter(GetEntityRecordsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> ORDER_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrderBy").getter(GetEntityRecordsRequest.getter(GetEntityRecordsRequest::orderBy)).setter(GetEntityRecordsRequest.setter(Builder::orderBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderBy").build()}).build();
    private static final SdkField<List<String>> SELECTED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedFields").getter(GetEntityRecordsRequest.getter(GetEntityRecordsRequest::selectedFields)).setter(GetEntityRecordsRequest.setter(Builder::selectedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NAME_FIELD, CATALOG_ID_FIELD, ENTITY_NAME_FIELD, NEXT_TOKEN_FIELD, DATA_STORE_API_VERSION_FIELD, CONNECTION_OPTIONS_FIELD, FILTER_PREDICATE_FIELD, LIMIT_FIELD, ORDER_BY_FIELD, SELECTED_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetEntityRecordsRequest.memberNameToFieldInitializer();
    private final String connectionName;
    private final String catalogId;
    private final String entityName;
    private final String nextToken;
    private final String dataStoreApiVersion;
    private final Map<String, String> connectionOptions;
    private final String filterPredicate;
    private final Long limit;
    private final String orderBy;
    private final List<String> selectedFields;

    private GetEntityRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.connectionName = builder.connectionName;
        this.catalogId = builder.catalogId;
        this.entityName = builder.entityName;
        this.nextToken = builder.nextToken;
        this.dataStoreApiVersion = builder.dataStoreApiVersion;
        this.connectionOptions = builder.connectionOptions;
        this.filterPredicate = builder.filterPredicate;
        this.limit = builder.limit;
        this.orderBy = builder.orderBy;
        this.selectedFields = builder.selectedFields;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String entityName() {
        return this.entityName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String dataStoreApiVersion() {
        return this.dataStoreApiVersion;
    }

    public final boolean hasConnectionOptions() {
        return this.connectionOptions != null && !(this.connectionOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> connectionOptions() {
        return this.connectionOptions;
    }

    public final String filterPredicate() {
        return this.filterPredicate;
    }

    public final Long limit() {
        return this.limit;
    }

    public final String orderBy() {
        return this.orderBy;
    }

    public final boolean hasSelectedFields() {
        return this.selectedFields != null && !(this.selectedFields instanceof SdkAutoConstructList);
    }

    public final List<String> selectedFields() {
        return this.selectedFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStoreApiVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionOptions() ? this.connectionOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPredicate());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedFields() ? this.selectedFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEntityRecordsRequest)) {
            return false;
        }
        GetEntityRecordsRequest other = (GetEntityRecordsRequest)((Object)obj);
        return Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.entityName(), other.entityName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.dataStoreApiVersion(), other.dataStoreApiVersion()) && this.hasConnectionOptions() == other.hasConnectionOptions() && Objects.equals(this.connectionOptions(), other.connectionOptions()) && Objects.equals(this.filterPredicate(), other.filterPredicate()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.orderBy(), other.orderBy()) && this.hasSelectedFields() == other.hasSelectedFields() && Objects.equals(this.selectedFields(), other.selectedFields());
    }

    public final String toString() {
        return ToString.builder((String)"GetEntityRecordsRequest").add("ConnectionName", (Object)this.connectionName()).add("CatalogId", (Object)this.catalogId()).add("EntityName", (Object)this.entityName()).add("NextToken", (Object)this.nextToken()).add("DataStoreApiVersion", (Object)this.dataStoreApiVersion()).add("ConnectionOptions", this.hasConnectionOptions() ? this.connectionOptions() : null).add("FilterPredicate", (Object)this.filterPredicate()).add("Limit", (Object)this.limit()).add("OrderBy", (Object)this.orderBy()).add("SelectedFields", this.hasSelectedFields() ? this.selectedFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "EntityName": {
                return Optional.ofNullable(clazz.cast(this.entityName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DataStoreApiVersion": {
                return Optional.ofNullable(clazz.cast(this.dataStoreApiVersion()));
            }
            case "ConnectionOptions": {
                return Optional.ofNullable(clazz.cast(this.connectionOptions()));
            }
            case "FilterPredicate": {
                return Optional.ofNullable(clazz.cast(this.filterPredicate()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "OrderBy": {
                return Optional.ofNullable(clazz.cast(this.orderBy()));
            }
            case "SelectedFields": {
                return Optional.ofNullable(clazz.cast(this.selectedFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectionName", CONNECTION_NAME_FIELD);
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("EntityName", ENTITY_NAME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("DataStoreApiVersion", DATA_STORE_API_VERSION_FIELD);
        map.put("ConnectionOptions", CONNECTION_OPTIONS_FIELD);
        map.put("FilterPredicate", FILTER_PREDICATE_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("OrderBy", ORDER_BY_FIELD);
        map.put("SelectedFields", SELECTED_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEntityRecordsRequest, T> g) {
        return obj -> g.apply((GetEntityRecordsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String connectionName;
        private String catalogId;
        private String entityName;
        private String nextToken;
        private String dataStoreApiVersion;
        private Map<String, String> connectionOptions = DefaultSdkAutoConstructMap.getInstance();
        private String filterPredicate;
        private Long limit;
        private String orderBy;
        private List<String> selectedFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEntityRecordsRequest model) {
            super(model);
            this.connectionName(model.connectionName);
            this.catalogId(model.catalogId);
            this.entityName(model.entityName);
            this.nextToken(model.nextToken);
            this.dataStoreApiVersion(model.dataStoreApiVersion);
            this.connectionOptions(model.connectionOptions);
            this.filterPredicate(model.filterPredicate);
            this.limit(model.limit);
            this.orderBy(model.orderBy);
            this.selectedFields(model.selectedFields);
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getEntityName() {
            return this.entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getDataStoreApiVersion() {
            return this.dataStoreApiVersion;
        }

        public final void setDataStoreApiVersion(String dataStoreApiVersion) {
            this.dataStoreApiVersion = dataStoreApiVersion;
        }

        @Override
        public final Builder dataStoreApiVersion(String dataStoreApiVersion) {
            this.dataStoreApiVersion = dataStoreApiVersion;
            return this;
        }

        public final Map<String, String> getConnectionOptions() {
            if (this.connectionOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.connectionOptions;
        }

        public final void setConnectionOptions(Map<String, String> connectionOptions) {
            this.connectionOptions = ConnectionOptionsCopier.copy(connectionOptions);
        }

        @Override
        public final Builder connectionOptions(Map<String, String> connectionOptions) {
            this.connectionOptions = ConnectionOptionsCopier.copy(connectionOptions);
            return this;
        }

        public final String getFilterPredicate() {
            return this.filterPredicate;
        }

        public final void setFilterPredicate(String filterPredicate) {
            this.filterPredicate = filterPredicate;
        }

        @Override
        public final Builder filterPredicate(String filterPredicate) {
            this.filterPredicate = filterPredicate;
            return this;
        }

        public final Long getLimit() {
            return this.limit;
        }

        public final void setLimit(Long limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public final String getOrderBy() {
            return this.orderBy;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Collection<String> getSelectedFields() {
            if (this.selectedFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedFields;
        }

        public final void setSelectedFields(Collection<String> selectedFields) {
            this.selectedFields = SelectedFieldsCopier.copy(selectedFields);
        }

        @Override
        public final Builder selectedFields(Collection<String> selectedFields) {
            this.selectedFields = SelectedFieldsCopier.copy(selectedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedFields(String ... selectedFields) {
            this.selectedFields(Arrays.asList(selectedFields));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEntityRecordsRequest build() {
            return new GetEntityRecordsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEntityRecordsRequest> {
        public Builder connectionName(String var1);

        public Builder catalogId(String var1);

        public Builder entityName(String var1);

        public Builder nextToken(String var1);

        public Builder dataStoreApiVersion(String var1);

        public Builder connectionOptions(Map<String, String> var1);

        public Builder filterPredicate(String var1);

        public Builder limit(Long var1);

        public Builder orderBy(String var1);

        public Builder selectedFields(Collection<String> var1);

        public Builder selectedFields(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

