/*
 * Decompiled with CFR 0.152.
 */
package ru.ivi.opensource.flinkclickhousesink.model;

import java.util.List;

public class ClickHouseRequestBlank {
    private final List<String> values;
    private final String targetTable;
    private int attemptCounter;
    private Exception exception;

    public ClickHouseRequestBlank(List<String> values, String targetTable, Exception exception) {
        this.values = values;
        this.targetTable = targetTable;
        this.attemptCounter = 0;
        this.exception = exception;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void incrementCounter() {
        ++this.attemptCounter;
    }

    public int getAttemptCounter() {
        return this.attemptCounter;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public String toString() {
        return "ClickHouseRequestBlank{values=" + this.values + ", targetTable='" + this.targetTable + '\'' + ", attemptCounter=" + this.attemptCounter + ", exception=" + this.exception + '}';
    }

    public static final class Builder {
        private List<String> values;
        private String targetTable;
        private Exception exception;

        private Builder() {
        }

        public static Builder aBuilder() {
            return new Builder();
        }

        public Builder withValues(List<String> values) {
            this.values = values;
            return this;
        }

        public Builder withTargetTable(String targetTable) {
            this.targetTable = targetTable;
            return this;
        }

        public Builder withException(Exception exception) {
            this.exception = exception;
            return this;
        }

        public ClickHouseRequestBlank build() {
            return new ClickHouseRequestBlank(this.values, this.targetTable, this.exception);
        }
    }
}

