/*
 * Decompiled with CFR 0.152.
 */
package ru.ivi.opensource.flinkclickhousesink.applied;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ivi.opensource.flinkclickhousesink.applied.ClickHouseWriter;
import ru.ivi.opensource.flinkclickhousesink.model.ClickHouseRequestBlank;
import ru.ivi.opensource.flinkclickhousesink.util.FutureUtil;

public class ClickHouseSinkBuffer
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ClickHouseSinkBuffer.class);
    private final ClickHouseWriter writer;
    private final String targetTable;
    private final int maxFlushBufferSize;
    private final long timeoutMillis;
    private final List<String> localValues;
    private final List<CompletableFuture<Boolean>> futures;
    private volatile long lastAddTimeMillis = System.currentTimeMillis();

    private ClickHouseSinkBuffer(ClickHouseWriter chWriter, long timeout, int maxBuffer, String table, List<CompletableFuture<Boolean>> futures) {
        this.writer = chWriter;
        this.localValues = new ArrayList<String>();
        this.timeoutMillis = timeout;
        this.maxFlushBufferSize = maxBuffer;
        this.targetTable = table;
        this.futures = futures;
        logger.info("Instance ClickHouse Sink, target table = {}, buffer size = {}", (Object)this.targetTable, (Object)this.maxFlushBufferSize);
    }

    String getTargetTable() {
        return this.targetTable;
    }

    public void put(String recordAsCSV) {
        this.tryAddToQueue();
        this.localValues.add(recordAsCSV);
    }

    synchronized void tryAddToQueue() {
        if (this.flushCondition()) {
            this.addToQueue();
            this.lastAddTimeMillis = System.currentTimeMillis();
        }
    }

    private void addToQueue() {
        List<String> deepCopy = ClickHouseSinkBuffer.buildDeepCopy(this.localValues);
        ClickHouseRequestBlank params = ClickHouseRequestBlank.Builder.aBuilder().withValues(deepCopy).withTargetTable(this.targetTable).build();
        logger.debug("Build blank with params: buffer size = {}, target table  = {}", (Object)params.getValues().size(), (Object)params.getTargetTable());
        this.writer.put(params);
        this.localValues.clear();
    }

    private boolean flushCondition() {
        return this.localValues.size() > 0 && (this.checkSize() || this.checkTime());
    }

    private boolean checkSize() {
        return this.localValues.size() >= this.maxFlushBufferSize;
    }

    private boolean checkTime() {
        long current = System.currentTimeMillis();
        return current - this.lastAddTimeMillis > this.timeoutMillis;
    }

    private static List<String> buildDeepCopy(List<String> original) {
        return Collections.unmodifiableList(new ArrayList<String>(original));
    }

    public void assertFuturesNotFailedYet() throws ExecutionException, InterruptedException {
        CompletableFuture<Void> future = FutureUtil.allOf(this.futures);
        if (future.isCompletedExceptionally()) {
            future.get();
        }
    }

    @Override
    public void close() {
        logger.info("ClickHouse sink buffer is shutting down.");
        if (this.localValues != null && this.localValues.size() > 0) {
            this.addToQueue();
        }
        logger.info("ClickHouse sink buffer shutdown complete.");
    }

    public static final class Builder {
        private String targetTable;
        private int maxFlushBufferSize;
        private int timeoutSec;
        private List<CompletableFuture<Boolean>> futures;

        private Builder() {
        }

        public static Builder aClickHouseSinkBuffer() {
            return new Builder();
        }

        public Builder withTargetTable(String targetTable) {
            this.targetTable = targetTable;
            return this;
        }

        public Builder withMaxFlushBufferSize(int maxFlushBufferSize) {
            this.maxFlushBufferSize = maxFlushBufferSize;
            return this;
        }

        public Builder withTimeoutSec(int timeoutSec) {
            this.timeoutSec = timeoutSec;
            return this;
        }

        public Builder withFutures(List<CompletableFuture<Boolean>> futures) {
            this.futures = futures;
            return this;
        }

        public ClickHouseSinkBuffer build(ClickHouseWriter writer) {
            Preconditions.checkNotNull((Object)this.targetTable);
            Preconditions.checkArgument((this.maxFlushBufferSize > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((this.timeoutSec > 0 ? 1 : 0) != 0);
            return new ClickHouseSinkBuffer(writer, TimeUnit.SECONDS.toMillis(this.timeoutSec), this.maxFlushBufferSize, this.targetTable, this.futures);
        }
    }
}

