/*
 * Decompiled with CFR 0.152.
 */
package ru.ivi.opensource.flinkclickhousesink.model;

import com.google.common.base.Preconditions;
import java.util.Map;
import ru.ivi.opensource.flinkclickhousesink.model.ClickHouseClusterSettings;

public class ClickHouseSinkCommonParams {
    private final ClickHouseClusterSettings clickHouseClusterSettings;
    private final String failedRecordsPath;
    private final int numWriters;
    private final int queueMaxCapacity;
    private final boolean ignoringClickHouseSendingExceptionEnabled;
    private final int timeout;
    private final int maxRetries;

    public ClickHouseSinkCommonParams(Map<String, String> params) {
        Preconditions.checkNotNull((Object)params.get("clickhouse.sink.ignoring-clickhouse-sending-exception-enabled"), (Object)"Parameter clickhouse.sink.ignoring-clickhouse-sending-exception-enabled must be initialized");
        this.clickHouseClusterSettings = new ClickHouseClusterSettings(params);
        this.numWriters = Integer.parseInt(params.get("clickhouse.sink.num-writers"));
        this.queueMaxCapacity = Integer.parseInt(params.get("clickhouse.sink.queue-max-capacity"));
        this.maxRetries = Integer.parseInt(params.get("clickhouse.sink.retries"));
        this.timeout = Integer.parseInt(params.get("clickhouse.sink.timeout-sec"));
        this.failedRecordsPath = params.get("clickhouse.sink.failed-records-path");
        this.ignoringClickHouseSendingExceptionEnabled = Boolean.parseBoolean(params.get("clickhouse.sink.ignoring-clickhouse-sending-exception-enabled"));
        Preconditions.checkNotNull((Object)this.failedRecordsPath);
        Preconditions.checkArgument((this.queueMaxCapacity > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.numWriters > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.timeout > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.maxRetries > 0 ? 1 : 0) != 0);
    }

    public int getNumWriters() {
        return this.numWriters;
    }

    public int getQueueMaxCapacity() {
        return this.queueMaxCapacity;
    }

    public boolean isIgnoringClickHouseSendingExceptionEnabled() {
        return this.ignoringClickHouseSendingExceptionEnabled;
    }

    public ClickHouseClusterSettings getClickHouseClusterSettings() {
        return this.clickHouseClusterSettings;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public String getFailedRecordsPath() {
        return this.failedRecordsPath;
    }

    public String toString() {
        return "ClickHouseSinkCommonParams{clickHouseClusterSettings=" + this.clickHouseClusterSettings + ", failedRecordsPath='" + this.failedRecordsPath + '\'' + ", numWriters=" + this.numWriters + ", queueMaxCapacity=" + this.queueMaxCapacity + ", ignoringClickHouseSendingExceptionEnabled=" + this.ignoringClickHouseSendingExceptionEnabled + ", timeout=" + this.timeout + ", maxRetries=" + this.maxRetries + '}';
    }
}

