/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.function.Supplier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Endpoint;
import redis.clients.jedis.RedisCredentials;
import redis.clients.jedis.SslOptions;
import redis.clients.jedis.SslVerifyMode;
import redis.clients.jedis.annots.Internal;

@Internal
class RedisRestAPI {
    private static final Logger log = LoggerFactory.getLogger(RedisRestAPI.class);
    private static final String BDBS_URL = "https://%s:%s/v1/bdbs?fields=uid,endpoints";
    private static final String AVAILABILITY_URL = "https://%s:%s/v1/bdbs/%s/availability";
    private static final String LAGAWARE_AVAILABILITY_URL = "https://%s:%s/v1/bdbs/%s/availability?extend_check=lag";
    private static final int DEFAULT_TIMEOUT_MS = 1000;
    private final Endpoint endpoint;
    private final Supplier<RedisCredentials> credentialsSupplier;
    private final int timeoutMs;
    private final SslOptions sslOptions;
    private String bdbsUri;

    public RedisRestAPI(Endpoint endpoint, Supplier<RedisCredentials> credentialsSupplier) {
        this(endpoint, credentialsSupplier, 1000);
    }

    public RedisRestAPI(Endpoint endpoint, Supplier<RedisCredentials> credentialsSupplier, int timeoutMs) {
        this(endpoint, credentialsSupplier, timeoutMs, null);
    }

    public RedisRestAPI(Endpoint endpoint, Supplier<RedisCredentials> credentialsSupplier, int timeoutMs, SslOptions sslOptions) {
        this.endpoint = endpoint;
        this.credentialsSupplier = credentialsSupplier;
        this.timeoutMs = timeoutMs;
        this.sslOptions = sslOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BdbInfo> getBdbs() throws IOException {
        if (this.bdbsUri == null) {
            this.bdbsUri = String.format(BDBS_URL, this.endpoint.getHost(), this.endpoint.getPort());
        }
        HttpURLConnection conn = null;
        try {
            conn = this.createConnection(this.bdbsUri, "GET", this.credentialsSupplier.get());
            conn.setRequestProperty("Accept", "application/json");
            int code = conn.getResponseCode();
            String responseBody = RedisRestAPI.readResponse(conn);
            if (code != 200) {
                throw new IOException("Unexpected response code '" + code + "' for getBdbs: '" + responseBody + "' from '" + this.bdbsUri + "'");
            }
            List<BdbInfo> list = RedisRestAPI.parseBdbInfoFromResponse(responseBody);
            return list;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public boolean checkBdbAvailability(String uid, boolean lagAware) throws IOException {
        return this.checkBdbAvailability(uid, lagAware, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkBdbAvailability(String uid, boolean extendedCheckEnabled, Long availabilityLagToleranceMs) throws IOException {
        String availabilityUri;
        if (extendedCheckEnabled) {
            availabilityUri = String.format(LAGAWARE_AVAILABILITY_URL, this.endpoint.getHost(), this.endpoint.getPort(), uid);
            if (availabilityLagToleranceMs != null) {
                availabilityUri = availabilityUri + "&availability_lag_tolerance_ms=" + availabilityLagToleranceMs;
            }
        } else {
            availabilityUri = String.format(AVAILABILITY_URL, this.endpoint.getHost(), this.endpoint.getPort(), uid);
        }
        HttpURLConnection conn = null;
        try {
            conn = this.createConnection(availabilityUri, "GET", this.credentialsSupplier.get());
            conn.setRequestProperty("Accept", "application/json");
            int code = conn.getResponseCode();
            if (code == 200) {
                boolean bl = true;
                return bl;
            }
            String body = RedisRestAPI.readResponse(conn);
            log.warn("Availability check for {} returned body='{}' from '{}'", new Object[]{uid, body, availabilityUri});
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return false;
    }

    HttpURLConnection createConnection(String urlString, String method, RedisCredentials credentials) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (connection instanceof HttpsURLConnection && this.sslOptions != null) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            try {
                SSLContext sslContext = this.sslOptions.createSslContext();
                httpsConnection.setSSLSocketFactory(sslContext.getSocketFactory());
                if (this.sslOptions.getSslVerifyMode() == SslVerifyMode.CA || this.sslOptions.getSslVerifyMode() == SslVerifyMode.INSECURE) {
                    httpsConnection.setHostnameVerifier((h, s) -> true);
                }
            }
            catch (GeneralSecurityException e) {
                throw new IOException("SSL configuration failed", e);
            }
        }
        connection.setRequestMethod(method);
        connection.setConnectTimeout(this.timeoutMs);
        connection.setReadTimeout(this.timeoutMs);
        connection.setRequestProperty("Authorization", RedisRestAPI.getAuthenticationHeader(credentials));
        return connection;
    }

    private static String getAuthenticationHeader(RedisCredentials credentials) throws IOException {
        char[] pass = credentials.getPassword() != null ? credentials.getPassword() : new char[]{};
        String user = credentials.getUser() != null ? credentials.getUser() : "";
        byte[] userBytes = user.getBytes(StandardCharsets.UTF_8);
        ByteBuffer bb = StandardCharsets.UTF_8.encode(CharBuffer.wrap(pass));
        byte[] passBytes = new byte[bb.remaining()];
        bb.get(passBytes);
        byte[] combined = new byte[userBytes.length + 1 + passBytes.length];
        System.arraycopy(userBytes, 0, combined, 0, userBytes.length);
        combined[userBytes.length] = 58;
        System.arraycopy(passBytes, 0, combined, userBytes.length + 1, passBytes.length);
        String encodedAuth = Base64.getEncoder().encodeToString(combined);
        Arrays.fill(passBytes, (byte)0);
        Arrays.fill(combined, (byte)0);
        return "Basic " + encodedAuth;
    }

    static List<BdbInfo> parseBdbInfoFromResponse(String responseBody) {
        JsonArray bdbs = JsonParser.parseString((String)responseBody).getAsJsonArray();
        ArrayList<BdbInfo> bdbInfoList = new ArrayList<BdbInfo>();
        for (JsonElement bdbElement : bdbs) {
            JsonObject bdb;
            if (!bdbElement.isJsonObject() || !(bdb = bdbElement.getAsJsonObject()).has("uid")) continue;
            String bdbId = bdb.get("uid").getAsString();
            ArrayList<EndpointInfo> endpoints = new ArrayList<EndpointInfo>();
            if (bdb.has("endpoints") && bdb.get("endpoints").isJsonArray()) {
                JsonArray endpointsArray = bdb.getAsJsonArray("endpoints");
                for (JsonElement endpointElement : endpointsArray) {
                    if (!endpointElement.isJsonObject()) continue;
                    JsonObject endpoint = endpointElement.getAsJsonObject();
                    ArrayList<String> addrList = new ArrayList<String>();
                    if (endpoint.has("addr") && endpoint.get("addr").isJsonArray()) {
                        JsonArray addresses = endpoint.getAsJsonArray("addr");
                        for (JsonElement addrElement : addresses) {
                            if (!addrElement.isJsonPrimitive()) continue;
                            addrList.add(addrElement.getAsString());
                        }
                    }
                    String dnsName = endpoint.has("dns_name") ? endpoint.get("dns_name").getAsString() : null;
                    Integer port = endpoint.has("port") ? Integer.valueOf(endpoint.get("port").getAsInt()) : null;
                    String endpointUid = endpoint.has("uid") ? endpoint.get("uid").getAsString() : null;
                    endpoints.add(new EndpointInfo(addrList, dnsName, port, endpointUid));
                }
            }
            bdbInfoList.add(new BdbInfo(bdbId, endpoints));
        }
        return bdbInfoList;
    }

    static String readResponse(HttpURLConnection connection) throws IOException {
        int bytesRead;
        InputStream inputStream = null;
        try {
            inputStream = connection.getInputStream();
            if (inputStream == null) {
                inputStream = connection.getErrorStream();
            }
        }
        catch (IOException e) {
            inputStream = connection.getErrorStream();
        }
        if (inputStream == null) {
            throw new IOException("No response stream available from server (code=" + connection.getResponseCode() + ")");
        }
        StringBuilder response = new StringBuilder();
        byte[] buffer = new byte[1024];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            response.append(new String(buffer, 0, bytesRead, StandardCharsets.UTF_8));
        }
        inputStream.close();
        return response.toString();
    }

    static class EndpointInfo {
        private final List<String> addr;
        private final String dnsName;
        private final Integer port;
        private final String uid;

        EndpointInfo(List<String> addr, String dnsName, Integer port, String uid) {
            this.addr = addr;
            this.dnsName = dnsName;
            this.port = port;
            this.uid = uid;
        }

        List<String> getAddr() {
            return this.addr;
        }

        String getDnsName() {
            return this.dnsName;
        }

        Integer getPort() {
            return this.port;
        }

        String getUid() {
            return this.uid;
        }

        public String toString() {
            return "EndpointInfo{addr=" + this.addr + ", dnsName='" + this.dnsName + '\'' + ", port=" + this.port + ", uid='" + this.uid + '\'' + '}';
        }
    }

    static class BdbInfo {
        private final String uid;
        private final List<EndpointInfo> endpoints;

        BdbInfo(String uid, List<EndpointInfo> endpoints) {
            this.uid = uid;
            this.endpoints = endpoints;
        }

        String getUid() {
            return this.uid;
        }

        List<EndpointInfo> getEndpoints() {
            return this.endpoints;
        }

        static BdbInfo findMatchingBdb(List<BdbInfo> bdbs, String dbHost) {
            for (BdbInfo bdb : bdbs) {
                for (EndpointInfo endpoint : bdb.getEndpoints()) {
                    if (dbHost.equals(endpoint.getDnsName())) {
                        return bdb;
                    }
                    if (endpoint.getAddr() == null) continue;
                    for (String addr : endpoint.getAddr()) {
                        if (!dbHost.equals(addr)) continue;
                        return bdb;
                    }
                }
            }
            return null;
        }

        public String toString() {
            return "BdbInfo{uid='" + this.uid + '\'' + ", endpoints=" + this.endpoints + '}';
        }
    }
}

