/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit.ldap.internal.jndi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import javax.naming.Context;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.zapodot.junit.ldap.internal.jndi.ContextInterceptor;
import org.zapodot.junit.ldap.internal.jndi.ContextProxy;
import org.zapodot.junit.ldap.internal.jndi.DirContextProxy;

public class ContextProxyFactory {
    private static final String DELEGATED_CONTEXT_FIELD_NAME = "delegatedContext";
    private static final String DELEGATED_DIR_CONTEXT_FIELD_NAME = "delegatedDirContext";
    private static final String DELEGATING_DIR_CONTEXT_PREFIX = "DelegatingDirContext";
    private static final Class<? extends Context> CONTEXT_PROXY_TYPE = new ByteBuddy().subclass(Context.class).name(new NamingStrategy.PrefixingRandom("DelegatingContext").subclass((TypeDescription.Generic)new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Context.class))).method((ElementMatcher)ElementMatchers.isDeclaredBy(Context.class).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.named((String)"close"))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isNative()))).intercept((Implementation)MethodDelegation.toField((String)"delegatedContext")).defineField("delegatedContext", Context.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).method((ElementMatcher)ElementMatchers.isDeclaredBy(Context.class).and((ElementMatcher)ElementMatchers.named((String)"close"))).intercept((Implementation)MethodDelegation.to(ContextInterceptor.class)).implement(new Type[]{ContextProxy.class}).intercept((Implementation)FieldAccessor.ofBeanProperty()).make().load(ContextProxyFactory.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();
    private static final Class<? extends DirContext> DIR_CONTEXT_PROXY_TYPE = new ByteBuddy().subclass(DirContext.class).name(new NamingStrategy.PrefixingRandom("DelegatingDirContext").subclass((TypeDescription.Generic)new TypeDescription.Generic.OfNonGenericType.ForLoadedType(DirContext.class))).method((ElementMatcher)ElementMatchers.isDeclaredBy(DirContext.class)).intercept((Implementation)MethodDelegation.toField((String)"delegatedDirContext")).defineField("delegatedDirContext", DirContext.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).implement(new Type[]{DirContextProxy.class}).intercept((Implementation)FieldAccessor.ofBeanProperty()).make().load(ContextProxyFactory.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();

    private ContextProxyFactory() {
    }

    public static Context asDelegatingContext(InitialDirContext initialDirContext) {
        return ContextProxyFactory.createProxy(initialDirContext);
    }

    private static Context createProxy(InitialDirContext initialDirContext) {
        try {
            Context contextDelegator = ContextProxyFactory.getDeclaredConstructor().newInstance(new Object[0]);
            ((ContextProxy)((Object)contextDelegator)).setDelegatedContext(initialDirContext);
            return contextDelegator;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Constructor<? extends Context> getDeclaredConstructor() {
        try {
            return CONTEXT_PROXY_TYPE.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Can not find a default constructor for proxy class", e);
        }
    }

    public static DirContext asDelegatingDirContext(InitialDirContext initialDirContext) {
        try {
            DirContext dirContext = DIR_CONTEXT_PROXY_TYPE.newInstance();
            ((DirContextProxy)((Object)dirContext)).setDelegatedDirContext(initialDirContext);
            return dirContext;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Could not wrap DirContext", e);
        }
    }
}

