/*
 * Decompiled with CFR 0.152.
 */
package org.yeauty.util;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.net.URL;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public final class SslUtils {
    public static SslContext createSslContext(String keyPassword, String keyStoreResource, String keyStoreType, String keyStorePassword, String trustStoreResource, String trustStoreType, String trustStorePassword) throws SSLException {
        SslContextBuilder sslBuilder = SslContextBuilder.forServer((KeyManagerFactory)SslUtils.getKeyManagerFactory(keyStoreType, keyStoreResource, keyPassword, keyStorePassword)).trustManager(SslUtils.getTrustManagerFactory(trustStoreType, trustStoreResource, trustStorePassword));
        return sslBuilder.build();
    }

    private static KeyManagerFactory getKeyManagerFactory(String type, String resource, String keyPassword, String keyStorePassword) {
        try {
            char[] keyPasswordBytes;
            KeyStore keyStore = SslUtils.loadKeyStore(type, resource, keyStorePassword);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            char[] cArray = keyPasswordBytes = !StringUtils.isEmpty((Object)keyPassword) ? keyPassword.toCharArray() : null;
            if (keyPasswordBytes == null && !StringUtils.isEmpty((Object)keyStorePassword)) {
                keyPasswordBytes = keyStorePassword.toCharArray();
            }
            keyManagerFactory.init(keyStore, keyPasswordBytes);
            return keyManagerFactory;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static TrustManagerFactory getTrustManagerFactory(String trustStoreType, String trustStoreResource, String trustStorePassword) {
        try {
            KeyStore store = SslUtils.loadKeyStore(trustStoreType, trustStoreResource, trustStorePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(store);
            return trustManagerFactory;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static KeyStore loadKeyStore(String type, String resource, String password) throws Exception {
        String string = type = StringUtils.isEmpty((Object)type) ? "JKS" : type;
        if (StringUtils.isEmpty((Object)resource)) {
            return null;
        }
        KeyStore store = KeyStore.getInstance(type);
        URL url = ResourceUtils.getURL((String)resource);
        store.load(url.openStream(), StringUtils.isEmpty((Object)password) ? null : password.toCharArray());
        return store;
    }
}

