/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlbeam.DomChangeTracker;
import org.xmlbeam.dom.DOMAccess;
import org.xmlbeam.evaluation.DefaultXPathEvaluator;
import org.xmlbeam.evaluation.InvocationContext;
import org.xmlbeam.intern.DOMChangeListener;
import org.xmlbeam.types.XBAutoList;
import org.xmlbeam.util.intern.DOMHelper;

class AutoList<E>
extends AbstractList<E>
implements XBAutoList<E>,
DOMChangeListener {
    private static final XBAutoList EMPTY = new EmptyAutoList();
    private final InvocationContext invocationContext;
    private Element parent;
    private final Node baseNode;
    private final List<Node> content = new ArrayList<Node>();
    private final DomChangeTracker domChangeTracker = new DomChangeTracker(){

        @Override
        void refresh(boolean forWrite) throws XPathExpressionException {
            NodeList nodes = (NodeList)AutoList.this.invocationContext.getxPathExpression().evaluate(AutoList.this.baseNode, XPathConstants.NODESET);
            if (nodes.getLength() == 0 && forWrite) {
                AutoList.this.parent = AutoList.this.invocationContext.getDuplexExpression().ensureParentExistence(AutoList.this.baseNode);
            } else {
                AutoList.this.parent = nodes.getLength() == 0 ? null : (Element)nodes.item(0).getParentNode();
            }
            AutoList.this.content.clear();
            for (int i = 0; i < nodes.getLength(); ++i) {
                AutoList.this.content.add(nodes.item(i));
            }
        }
    };

    public AutoList(Node baseNode, InvocationContext invocationContext) {
        this.invocationContext = invocationContext;
        this.baseNode = baseNode;
        this.invocationContext.getProjector().addDOMChangeListener(this);
    }

    @Override
    public E get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.domChangeTracker.refreshForReadIfNeeded();
        if (index >= this.content.size()) {
            throw new IndexOutOfBoundsException();
        }
        return DefaultXPathEvaluator.convertToComponentType(this.invocationContext, this.content.get(index), this.invocationContext.getTargetComponentType());
    }

    @Override
    public int size() {
        this.domChangeTracker.refreshForReadIfNeeded();
        return this.content.size();
    }

    @Override
    public E set(int index, E element) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.domChangeTracker.refreshForReadIfNeeded();
        if (index >= this.content.size()) {
            throw new IndexOutOfBoundsException();
        }
        Node oldNode = this.content.get(index);
        Object result = DefaultXPathEvaluator.convertToComponentType(this.invocationContext, oldNode, this.invocationContext.getTargetComponentType());
        if (element instanceof Node) {
            Node newNode = ((Node)element).cloneNode(true);
            oldNode.getParentNode().replaceChild(oldNode, newNode);
            this.content.set(index, newNode);
            return result;
        }
        if (element instanceof DOMAccess) {
            Node newNode = ((DOMAccess)element).getDOMBaseElement().cloneNode(true);
            oldNode.getParentNode().replaceChild(oldNode, newNode);
            this.content.set(index, newNode);
            return result;
        }
        String asString = this.invocationContext.getProjector().config().getStringRenderer().render(element.getClass(), element, this.invocationContext.getDuplexExpression().getExpressionFormatPattern());
        oldNode.setTextContent(asString);
        return result;
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            return false;
        }
        if (this.parent == null) {
            this.domChangeTracker.domChanged();
        }
        this.domChangeTracker.refreshForWriteIfNeeded();
        if (e instanceof Node) {
            this.content.add(DOMHelper.appendClone(this.parent, (Node)e));
            return true;
        }
        if (e instanceof DOMAccess) {
            this.content.add(DOMHelper.appendClone(this.parent, ((DOMAccess)e).getDOMBaseElement()));
            return true;
        }
        Node newElement = this.invocationContext.getDuplexExpression().createChildWithPredicate(this.parent);
        String asString = this.invocationContext.getProjector().config().getStringRenderer().render(e.getClass(), e, this.invocationContext.getDuplexExpression().getExpressionFormatPattern());
        newElement.setTextContent(asString);
        this.parent.appendChild(newElement);
        this.content.add(newElement);
        return true;
    }

    @Override
    public void add(int index, E o) {
        if (o == null) {
            throw new IllegalArgumentException("Can not add null to a ProjectedList. I don't know how to render that.");
        }
        this.domChangeTracker.refreshForWriteIfNeeded();
        if (index < 0 || index > this.content.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.content.size()) {
            this.add(o);
            return;
        }
        Node previousNode = this.content.get(index);
        if (o instanceof Node) {
            Node newValue = ((Node)o).cloneNode(true);
            previousNode.getParentNode().insertBefore(newValue, previousNode);
            this.content.add(index, newValue);
            return;
        }
        if (o instanceof DOMAccess) {
            Node newValue = ((DOMAccess)o).getDOMBaseElement().cloneNode(true);
            previousNode.getParentNode().insertBefore(newValue, previousNode);
            this.content.add(index, newValue);
            return;
        }
        Node newElement = this.invocationContext.getDuplexExpression().createChildWithPredicate(this.parent);
        String asString = this.invocationContext.getProjector().config().getStringRenderer().render(o.getClass(), o, this.invocationContext.getDuplexExpression().getExpressionFormatPattern());
        newElement.setTextContent(asString);
        this.parent.insertBefore(newElement, previousNode);
        this.content.add(index, newElement);
    }

    @Override
    public E remove(int index) {
        E result = this.get(index);
        Node remove = this.content.remove(index);
        Node p = remove.getParentNode();
        if (p != null) {
            p.removeChild(remove);
            DOMHelper.trim(p);
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        this.domChangeTracker.refreshForReadIfNeeded();
        if (this.content.isEmpty()) {
            return false;
        }
        if (o instanceof DOMAccess) {
            o = ((DOMAccess)o).getDOMBaseElement();
        }
        if (o instanceof Node) {
            boolean changed;
            for (Node contentNode : this.content) {
                if (!DOMHelper.nodesAreEqual(contentNode, (Node)o)) continue;
                o = contentNode;
                break;
            }
            if (changed = this.content.remove(o)) {
                Node p = ((Node)o).getParentNode();
                if (p != null) {
                    p.removeChild((Node)o);
                }
                DOMHelper.trim(p);
            }
            return changed;
        }
        String asString = this.invocationContext.getProjector().config().getStringRenderer().render(o.getClass(), o, this.invocationContext.getDuplexExpression().getExpressionFormatPattern());
        if (asString == null) {
            return false;
        }
        ListIterator<Node> i = this.content.listIterator();
        while (i.hasNext()) {
            Node item = i.next();
            if (!asString.equals(item.getTextContent())) continue;
            Node parentNode = item.getParentNode();
            assert (parentNode != null) : "How can child be in list without parent?";
            parentNode.removeChild(item);
            DOMHelper.trim(parentNode);
            i.remove();
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof Node)) {
            return super.indexOf(o);
        }
        this.domChangeTracker.refreshForReadIfNeeded();
        Node oNode = (Node)o;
        ListIterator<Node> e = this.content.listIterator();
        while (e.hasNext()) {
            if (!DOMHelper.nodesAreEqual(oNode, e.next())) continue;
            return e.previousIndex();
        }
        return -1;
    }

    @Override
    public void domChanged() {
        this.domChangeTracker.domChanged();
    }

    public Node getNode() {
        this.domChangeTracker.refreshForReadIfNeeded();
        return this.parent;
    }

    public static <E> XBAutoList<E> emptyList() {
        return EMPTY;
    }

    static class EmptyAutoList<F>
    extends AbstractList<F>
    implements XBAutoList<F> {
        EmptyAutoList() {
        }

        @Override
        public F get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int size() {
            return 0;
        }
    }
}

