/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Reflections {
    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static <T> T newInstance(String className, ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            return (T)clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isAccessible(String className, ClassLoader classLoader) {
        return Reflections.loadClass(className, classLoader) != null;
    }

    public static <T> Class<T> loadClass(String className, ClassLoader classLoader) {
        try {
            return (Class)Reflections.cast(classLoader.loadClass(className));
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static boolean containsAnnotation(Class<?> javaClass, Class<? extends Annotation> requiredAnnotation) {
        for (Class<?> clazz = javaClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            if ((clazz == javaClass || requiredAnnotation.isAnnotationPresent(Inherited.class)) && Reflections.containsAnnotations(clazz.getAnnotations(), requiredAnnotation)) {
                return true;
            }
            for (Field field : clazz.getDeclaredFields()) {
                if (!Reflections.containsAnnotations(field.getAnnotations(), requiredAnnotation)) continue;
                return true;
            }
            for (AccessibleObject accessibleObject : clazz.getConstructors()) {
                if (Reflections.containsAnnotations(accessibleObject.getAnnotations(), requiredAnnotation)) {
                    return true;
                }
                for (Annotation[] parameterAnnotations : ((Constructor)accessibleObject).getParameterAnnotations()) {
                    if (!Reflections.containsAnnotations(parameterAnnotations, requiredAnnotation)) continue;
                    return true;
                }
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (Reflections.containsAnnotations(accessibleObject.getAnnotations(), requiredAnnotation)) {
                    return true;
                }
                for (Annotation[] parameterAnnotations : ((Method)accessibleObject).getParameterAnnotations()) {
                    if (!Reflections.containsAnnotations(parameterAnnotations, requiredAnnotation)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean containsAnnotations(Annotation[] annotations, Class<? extends Annotation> requiredAnnotation) {
        return Reflections.containsAnnotation(annotations, requiredAnnotation, true);
    }

    private static boolean containsAnnotation(Annotation[] annotations, Class<? extends Annotation> requiredAnnotation, boolean checkMetaAnnotations) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (requiredAnnotation.equals(annotationType)) {
                return true;
            }
            if (!checkMetaAnnotations || !Reflections.containsAnnotation(annotationType.getAnnotations(), requiredAnnotation, false)) continue;
            return true;
        }
        return false;
    }
}

