/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.client.ClientRequest;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.jboss.ejb.client.EJBClientConnection;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceType;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryRequest;
import org.wildfly.discovery.spi.DiscoveryResult;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.common.WildflyHttpContext;
import org.wildfly.httpclient.ejb.EjbConstants;
import org.wildfly.httpclient.ejb.EjbHttpClientMessages;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.IoUtils;

public final class HttpEJBDiscoveryProvider
implements DiscoveryProvider {
    private static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private static final long CACHE_REFRESH_TIMEOUT = TimeUnit.MILLISECONDS.toNanos(Long.parseLong(WildFlySecurityManager.getPropertyPrivileged((String)"org.wildfly.httpclient.ejb.discovery.cache-refresh-timeout", (String)"300000")));
    private Set<ServiceURL> serviceURLCache = new HashSet<ServiceURL>();
    private AtomicBoolean cacheInvalid = new AtomicBoolean(true);
    private long cacheRefreshTimestamp = 0L;

    HttpEJBDiscoveryProvider() {
    }

    public DiscoveryRequest discover(ServiceType serviceType, FilterSpec filterSpec, DiscoveryResult discoveryResult) {
        EJBClientContext ejbClientContext = EJBClientContext.getCurrent();
        if (this.shouldRefreshCache()) {
            this.refreshCache(ejbClientContext);
        }
        this.searchCache(discoveryResult, filterSpec, ejbClientContext);
        return DiscoveryRequest.NULL;
    }

    private boolean shouldRefreshCache() {
        return this.cacheInvalid.get() || System.nanoTime() - this.cacheRefreshTimestamp > CACHE_REFRESH_TIMEOUT;
    }

    private boolean supportsScheme(String s) {
        switch (s) {
            case "http": 
            case "https": {
                return true;
            }
        }
        return false;
    }

    private void searchCache(DiscoveryResult discoveryResult, FilterSpec filterSpec, EJBClientContext ejbClientContext) {
        boolean resultsPresent = this.doSearchCache(discoveryResult, filterSpec);
        if (!resultsPresent) {
            this.refreshCache(ejbClientContext);
        }
        discoveryResult.complete();
    }

    private boolean doSearchCache(DiscoveryResult discoveryResult, FilterSpec filterSpec) {
        boolean resultsPresent = false;
        for (ServiceURL serviceURL : this.serviceURLCache) {
            if (!serviceURL.satisfies(filterSpec)) continue;
            discoveryResult.addMatch(serviceURL.getLocationURI());
            resultsPresent = true;
        }
        return resultsPresent;
    }

    private void refreshCache(EJBClientContext ejbClientContext) {
        this.serviceURLCache.clear();
        List httpConnections = ejbClientContext.getConfiguredConnections().stream().filter(connection -> this.supportsScheme(connection.getDestination().getScheme())).collect(Collectors.toList());
        CountDownLatch outstandingLatch = new CountDownLatch(httpConnections.size());
        for (EJBClientConnection connection2 : httpConnections) {
            this.discoverFromConnection(connection2, outstandingLatch);
        }
        try {
            outstandingLatch.await();
            this.cacheInvalid.set(false);
            this.cacheRefreshTimestamp = System.nanoTime();
        }
        catch (InterruptedException e) {
            EjbHttpClientMessages.MESSAGES.httpDiscoveryInterrupted(e);
        }
        this.cacheInvalid.set(false);
    }

    private void discoverFromConnection(EJBClientConnection connection, CountDownLatch outstandingLatch) {
        SSLContext sslContext;
        URI newUri = connection.getDestination();
        HttpTargetContext targetContext = WildflyHttpContext.getCurrent().getTargetContext(newUri);
        AuthenticationContext authenticationContext = AuthenticationContext.captureCurrent();
        AuthenticationContextConfigurationClient client = AUTH_CONFIGURATION_CLIENT;
        try {
            sslContext = client.getSSLContext(newUri, authenticationContext);
        }
        catch (GeneralSecurityException e2) {
            return;
        }
        AuthenticationConfiguration authenticationConfiguration = client.getAuthenticationConfiguration(newUri, authenticationContext, -1, "ejb", "jboss");
        ClientRequest request = new ClientRequest().setPath(targetContext.getUri().getPath() + "/ejb/v" + targetContext.getProtocolVersion() + "/discover").setMethod(Methods.GET);
        request.getRequestHeaders().add(Headers.ACCEPT, EjbConstants.EJB_DISCOVERY_RESPONSE + "," + EjbConstants.EJB_EXCEPTION);
        targetContext.sendRequest(request, sslContext, authenticationConfiguration, null, (result, response, closeable) -> {
            try {
                Unmarshaller unmarshaller = targetContext.getHttpMarshallerFactory(request).createUnmarshaller();
                unmarshaller.start((ByteInput)new InputStreamByteInput(result));
                int size = unmarshaller.readInt();
                for (int i = 0; i < size; ++i) {
                    EJBModuleIdentifier ejbModuleIdentifier = (EJBModuleIdentifier)unmarshaller.readObject();
                    ServiceURL url = this.createServiceURL(newUri, ejbModuleIdentifier);
                    this.serviceURLCache.add(url);
                }
            }
            catch (Exception e) {
                EjbHttpClientMessages.MESSAGES.unableToPerformEjbDiscovery(e);
            }
            finally {
                outstandingLatch.countDown();
                IoUtils.safeClose((Closeable)closeable);
            }
        }, e -> {
            EjbHttpClientMessages.MESSAGES.unableToPerformEjbDiscovery(e);
            outstandingLatch.countDown();
        }, EjbConstants.EJB_DISCOVERY_RESPONSE, null);
    }

    private ServiceURL createServiceURL(URI newUri, EJBModuleIdentifier moduleIdentifier) {
        ServiceURL.Builder builder = new ServiceURL.Builder();
        builder.setUri(newUri);
        builder.setAbstractType(EJBClientContext.EJB_SERVICE_TYPE.getAbstractType());
        builder.setAbstractTypeAuthority(EJBClientContext.EJB_SERVICE_TYPE.getAbstractTypeAuthority());
        String appName = moduleIdentifier.getAppName();
        String moduleName = moduleIdentifier.getModuleName();
        String distinctName = moduleIdentifier.getDistinctName();
        if (distinctName.isEmpty()) {
            if (appName.isEmpty()) {
                builder.addAttribute("ejb-module", AttributeValue.fromString((String)moduleName));
            } else {
                builder.addAttribute("ejb-module", AttributeValue.fromString((String)(appName + "/" + moduleName)));
            }
        } else if (appName.isEmpty()) {
            builder.addAttribute("ejb-module-distinct", AttributeValue.fromString((String)(moduleName + "/" + distinctName)));
        } else {
            builder.addAttribute("ejb-module-distinct", AttributeValue.fromString((String)(appName + "/" + moduleName + "/" + distinctName)));
        }
        return builder.create();
    }

    public void processMissingTarget(URI location, Exception cause) {
        this.cacheInvalid.set(true);
    }
}

