/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLElement;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class StaticEJBDiscoveryDefinition {
    public static final String APP = "app-name";
    public static final String MODULE = "module-name";
    public static final String DISTINCT = "distinct-name";
    public static final String URI = "uri";
    public static final String STATIC_EJB_DISCOVERY = "static-ejb-discovery";
    public static final SimpleAttributeDefinition APP_AD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("app-name", ModelType.STRING, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MODULE_AD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("module-name", ModelType.STRING, false).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition DISTINCT_AD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("distinct-name", ModelType.STRING, true).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition URI_AD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("uri", ModelType.STRING, false).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition[] VALUE_TYPE_FIELDS = new SimpleAttributeDefinition[]{URI_AD, APP_AD, MODULE_AD, DISTINCT_AD};
    private static final AttributeMarshaller VALUE_TYPE_MARSHALLER = new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (resourceModel.isDefined()) {
                writer.writeEmptyElement(EJB3SubsystemXMLElement.MODULE.getLocalName());
                for (SimpleAttributeDefinition valueType : VALUE_TYPE_FIELDS) {
                    valueType.getAttributeMarshaller().marshall((AttributeDefinition)valueType, resourceModel, true, writer);
                }
            }
        }
    };
    private static final ObjectTypeAttributeDefinition VALUE_TYPE_AD = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"module", (AttributeDefinition[])VALUE_TYPE_FIELDS).setAttributeMarshaller(VALUE_TYPE_MARSHALLER)).build();
    public static final AttributeDefinition INSTANCE = ((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"static-ejb-discovery", (ObjectTypeAttributeDefinition)VALUE_TYPE_AD).setRequired(false)).build();

    public static List<StaticEjbDiscovery> createStaticEjbList(OperationContext context, ModelNode ejbList) throws OperationFailedException {
        ArrayList<StaticEjbDiscovery> ret = new ArrayList<StaticEjbDiscovery>();
        if (ejbList.isDefined()) {
            for (ModelNode disc : ejbList.asList()) {
                ModelNode app = APP_AD.resolveModelAttribute(context, disc);
                String module = MODULE_AD.resolveModelAttribute(context, disc).asString();
                ModelNode distinct = DISTINCT_AD.resolveModelAttribute(context, disc);
                String url = URI_AD.resolveModelAttribute(context, disc).asString();
                ret.add(new StaticEjbDiscovery(app.isDefined() ? app.asString() : null, module, distinct.isDefined() ? distinct.asString() : null, url));
            }
        }
        return ret;
    }

    public static final class StaticEjbDiscovery {
        private final String app;
        private final String module;
        private final String distinct;
        private final String url;

        public StaticEjbDiscovery(String app, String module, String distinct, String url) {
            this.app = app;
            this.module = module;
            this.distinct = distinct;
            this.url = url;
        }

        public String getApp() {
            return this.app;
        }

        public String getModule() {
            return this.module;
        }

        public String getDistinct() {
            return this.distinct;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

