/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.Interceptors;

public final class ContainerInterceptorMethodInterceptorFactory
implements InterceptorFactory {
    private final ManagedReference interceptorInstanceRef;
    private final Method method;

    public ContainerInterceptorMethodInterceptorFactory(ManagedReference interceptorInstanceRef, Method method) {
        this.interceptorInstanceRef = interceptorInstanceRef;
        this.method = method;
    }

    public Interceptor create(InterceptorFactoryContext context) {
        return new ContainerInterceptorMethodInterceptor(this.interceptorInstanceRef, this.method);
    }

    private static final class ContainerInterceptorMethodInterceptor
    implements Interceptor {
        private final ManagedReference interceptorInstanceRef;
        private final Method method;

        ContainerInterceptorMethodInterceptor(ManagedReference interceptorInstanceRef, Method method) {
            this.method = method;
            this.interceptorInstanceRef = interceptorInstanceRef;
        }

        public Object processInvocation(InterceptorContext context) throws Exception {
            Object interceptorInstance = this.interceptorInstanceRef.getInstance();
            try {
                Method method = this.method;
                return method.invoke(interceptorInstance, context.getInvocationContext());
            }
            catch (IllegalAccessException e) {
                IllegalAccessError n = new IllegalAccessError(e.getMessage());
                n.setStackTrace(e.getStackTrace());
                throw n;
            }
            catch (InvocationTargetException e) {
                throw Interceptors.rethrow((Throwable)e.getCause());
            }
        }
    }
}

