/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.marshalling;

import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Function;
import org.infinispan.commons.dataconversion.MediaType;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.modules.ModuleLoader;
import org.wildfly.clustering.infinispan.marshalling.protostream.WrappedMessageByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.DynamicClassTable;
import org.wildfly.clustering.marshalling.jboss.DynamicExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ModuleClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;

public class ByteBufferMarshallerFactory
implements Function<ClassLoader, ByteBufferMarshaller> {
    private final MediaType type;
    private final ModuleLoader loader;

    public ByteBufferMarshallerFactory(MediaType type, ModuleLoader loader) {
        this.type = type;
        this.loader = loader;
    }

    @Override
    public ByteBufferMarshaller apply(ClassLoader loader) {
        switch (this.type.toString()) {
            case "application/octet-stream": {
                return new ProtoStreamByteBufferMarshaller(new SerializationContextBuilder((ClassLoaderMarshaller)new ModuleClassLoaderMarshaller(this.loader)).load(loader).build());
            }
            case "application/x-jboss-marshalling": {
                return new JBossByteBufferMarshaller((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(MarshallingVersion.class, (Enum)MarshallingVersion.CURRENT, new AbstractMap.SimpleImmutableEntry<ModularClassResolver, ClassLoader>(ModularClassResolver.getInstance((ModuleLoader)this.loader), loader)), loader);
            }
            case "application/x-protostream": {
                return new WrappedMessageByteBufferMarshaller(loader);
            }
        }
        throw new IllegalArgumentException(this.type.toString());
    }

    static enum MarshallingVersion implements Function<Map.Entry<ClassResolver, ClassLoader>, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(Map.Entry<ClassResolver, ClassLoader> entry) {
                MarshallingConfiguration config = new MarshallingConfiguration();
                ClassLoader loader = entry.getValue();
                config.setClassResolver(entry.getKey());
                config.setClassTable((ClassTable)new DynamicClassTable(loader));
                config.setObjectTable((ObjectTable)new DynamicExternalizerObjectTable(loader));
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_1;
        }
    }
}

