(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['exports', 'echarts'], factory);
    } else if (typeof exports === 'object' && typeof exports.nodeName !== 'string') {
        // CommonJS
        factory(exports, require('echarts'));
    } else {
        // Browser globals
        factory({}, root.echarts);
    }
}(this, function (exports, echarts) {
    var log = function (msg) {
        if (typeof console !== 'undefined') {
            console && console.error && console.error(msg);
        }
    }
    if (!echarts) {
        log('ECharts is not Loaded');
        return;
    }
    if (!echarts.registerMap) {
        log('ECharts Map is not loaded')
        return;
    }
    echarts.registerMap('海南', {"type":"FeatureCollection","features":[{"id":"460100","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@¢NDxBrCpI^OTGjGfBBBFFB\\PlRRPJhJ\\DC|K|Q¤kfGL@PDFAHGFMFENEJGNODK@OCE@AFAHEXGJEL@BEFAD@BC@MFGD@DAL_CKAEN@D@BBNKF@BEFEDGFCFICMAEJGDUBGAEKIAEHQJAXFN@DCBEJIJCBGACWMCG@CFGDYFKCEMEGEE@SAKFELBFEDEIEBIAKOGCEGAAACECCBCABIB@FDB@ACXA@CCAKAACBGAAEAEEAIEICOCCCAGEGSBEHKBIDA^IDE@ICEGBOCKBIGE@CAGBGGACJCJ@HDDABMGGFU@MAEFGPMFBHCHBTADCBCDAVBD@@AEEGAGEKABGC@CCDECIDIAEGIEMGECIIGAC@[AKFMDCEI@CFBDAAGBGCQGACIE@@AOEEDKACC@EGBCAEBGACFC@EA[CCAG@ECG@EDC@EBCDELEDC@OABDAFDDDJBBBFBF@HDJMCWBECAEA@UVGDC@ABC^ABM@IHGDABOEEK@ACAODGDK@EGDCAGACCAGBKFI@KHIBGDGNAJDLFJ@@EDC@CCAB@DCAKBEEABGAEBADCAAFA@AH@BABBFADBBC@BDADGA@BCB@FCDANEHGDAD@HADBNBXBFHJ@FAHXLFJBFAFCB@HEFCNIBBD@HDDADIAASCEeDCBIECBIFEBEACCEAOCEICCGOEEICABWJC@CAI@GAG@A@EGEDE@ECG@ACBKqGUIE@KJAHHFBTFNBBABCDAJQ@IBAT@BFDBJFF@LNFFNFADBABCBELDVCDYL@JGJIhABHR@H@FCFARWRGBIAMB@FHHPAHBET@BABCCMCAA]LEAKIMGC@C@CDAJ@BF@HDRA@FCF@DBVGHKDAFFJFDNF@DEHI@MLEJ@JDHB@DABCH@BDFBBBAFDABCJEDGB@AJID@DFBLA@BGFCCGBEBAFLZBBBBCH@FDBHBCLDFCREBACCAODGAILKBBNBHKJmx"],"encodeOffsets":[[112750,20508]]},"properties":{"cp":[110.33119,20.031971],"name":"海口市","childNum":1}},{"id":"460200","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@FDFFAF@DZRRD@B@LLTFDFFABJDLALPRDHADBHHLBJABCD@RdD@XMHDJHDBFFLDDLRE@ABCDDBABFRDREBDF@DDLDDADEJAFCFKDCTCVL@BEFBDJBBHFFAHBVCPCDEBAF@JCJBPBFDBDH@HBLBBF@BFJFANBHDFFDFBF@FCHA\\CRHJHF@FGLCD@VODINQLBFAHC@EACBMDIB@JHHDHEJBFFFJBLKVAFBHFJXZBLDFFDLDPDLLJ@NLJDNNNJNZNJHAFB@CHG@OCKFEACF@BC@CBGLU@GDCD@@A@CEIFGF@FDBBBFDABBB@LCFETIDCN@XFJEFALEJBFAL@DDFGBSDAFAZCPGFCBECWBG@A@EBC@OCCDMCEIGGIDIEEAQEC@I@ALI@GCGAIGGKFBMNMPE@ADABKLE@E@IBGFCJAJDFAFBDAFBBAH@@CTIHJNFNMHBDCFAJFF@D@DBBBDBDAFBDBDFDAF@LL@CJKJCHBJCB@DBHAD@@FBDLDFEDALFGN@DHF@HN@@LAF@JPTB@JIFAHI@@BB@HER@RDNBLFJLNFBFAB@@FCHDJCFBH@DP@NHHHDCNFNDDRBD@R@DH@HFHGD@HI@MBAECEQFOFENGV@BCJMHGFO@EAEGIAWCGCA]ECC@EDODEF[MEFGFBB@\\«UEQICCGUEmW{C]CgW¡QO]MeIgC_DUDO@QCeMc[YKWEWAUBMDWP_`IDO@}CUDMDGHM\\KJSH×VUJsRħI_BUBQLELIjMlEHGDSD½DAQCKGEGGCKGBGDGHYl"],"encodeOffsets":[[111547,18776]]},"properties":{"cp":[109.508268,18.247872],"name":"三亚市","childNum":1}},{"id":"460300","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@KCOLAJBJDDVFRHJB\\JfVXFZBRATGPMHS@KGKOKqO[QUGQCOAGFCZDFLA\\ALHHNLHNFT@JDBJELYAiQaEQE]W"],["@@HCFCFEBGEKMAMLCHAHRH"],["@@KDEFShGJSNGJGJIFCF@HBHDDDBXE^QbcR]DICMCGICEA"],["@@k^AXNV\\AcFOGWMMO@UDSL"],["@@HBJCBGEAKBAJ"],["@@DBB@BCAAC@AD"],["@@AAOHCLAVHPNHZJ|XLRKDKOYm]YEUIWQ[_"],["@@CdNbRNZINOFYIYYOSBQH"],["@@AZN^RHXKH[@WOG]BOF"],["@@HTHJjZLBNBTFNBRBNFXI`KHGHOAMKOOGKIKCeAsGSCMBOHGHMHEJ"],["@@hNpJxHfFVF\\BL@PKHYCSOG¯F_GYI[QmOU@cFGF@RNPbPND"],["@@yHEHAXDNLTTNPDLBªVfLNRARED@FQFSCQ[_MIOG[GýS"],["@@BEAsKISASfI`DTVRTCPa"],["@@@SEagBKjTZfE@I"],["@@EAUAWDIR@TNNbX\\PVDROCWGWi_"],["@@RaOaa@YTRbbPFA"],["@@FA\\QBEAESUCCOBGD@DBfDFHD"],["@@ICIB@BJHFADE"],["@@GCIBADJFHABE"],["@@VuKogEcbEld`dA"],["@@\\c]_gA]TClbRjK"],["@@AIKD@JH@FC"],["@@NOG[UKUHWVEZLNdETG"],["@@RG^WF]EISKklEVVR"],["@@DHFDRGHGAoOCWNFj"],["@@LRVBxO@a_SUCQJILG`"],["@@PJHAJ@HWOCQAGV"],["@@LAJKGMKDGD@JFJ"],["@@LJLBNIJMDMCIECKAUJIVBJ"],["@@@BLDNEJKCGIIICIFGFFV"],["@@Lg_aoNEh`\\jG"],["@@FHJFNABGGKSGEBBN"],["@@b^jFdOVgQcmCkFaPHf"],["@@xNRaMoiQQ`ATBb"],["@@nyBKISUIQIeA]FinB\\FJPJJDHDFDPARD^A"],["@@\\RXABGEKOKUIMCODBNHHJD"],["@@QwQKoBELARIVLNXN\\AfK"],["@@BCCMAEICHYGMMEQ@OLOXMN@RNJVZRA\\WJC"],["@@`@DATe@WAOCKGIq@UFEVHP@\\BLPPJB"],["@@\\EDCBQAEKKKqGE@[T@FBNHTP`f`FB"],["@@JAPGRUDI@KCMUOEAw@GDCN@THTVRNHHB"],["@@lOQe[SeRHf`R"],["@@@\\DHRNPFNDNARCR]@IAKIUECGA}@GBCHAP"],["@@DRNVZNH@TENKBGD_@KMOUII@MDIFKJEHCN"],["@@BhBDRNPFFAF@RKFQBKAMGIIEaCQHCF"],["@@BNTX\\RLBHCPcBM@gEYII]CWFILEXAb"],["@@DjHVJF\\DDA@UCwACEA]DIBAF"],["@@PbFDDDnBFCF]AKGI[KS@IDMNAF"],["@@LFHRDN@ROLOHs@kSWMEGBYVGLGVCX"],["@@@JTTVANELGn­HsGSecEAEHOªo"],["@@BjV\\lP|DbI@iK]wccKeDSd"],["@@DHdNrATSFMEWaaICiAEFKdEd"],["@@HLpRLEBMAK]K@kNEJC "],["@@FHJ^NRB^EFEFMBc_{ICwBGD"],["@@DPLPLHZ@JODYESOMQEMHILCV"],["@@BNJLLDrBREV]TaRWDSBWCQOG[BYDgVWRITENCt"],["@@BDNN\\PF@PCBCBEAUCMe[GAOBAB@j"],["@@BLFFnR`JXPNhCRKASIOoWkMUQ@MHIJAH@J"],["@@LLXDRGXGf@PIPOAOmKWAaDQPSVCN"],["@@BR\\hH@V@VCLEL_DUCOYkECI@UFKD[jAR"],["@@DJXNrRxGFEB_EeEGmQQ@aLGFWr"],["@@DVP\\^PÖfXn\\JFxxXPÜbHH¬äHHŬètVLElWPQ^¯AW[cÛ}w[kWÏAYGMßiŏ³ĉoÓAQBjQLqAP"],["@@JJLHLDfAvWÜ_LEFIDIKEYB}R¯rSVEHD\\@JEN"],["@@BHFF\\LF@dUBIOiII[GEBQPAF@j"],["@@Fr@FDBhJtADABGNyOoEEGCkCO@EBWtAJ"],["@@DTÎĂÒÒ|XJ¸@EM²]lQVQXUDSWQyHYF£RJ]@»QkI±çė·­uWOCWHEJ@|"],["@@HnNVLNÐ¦TNrRXCRCHQBS@KecsQM½YAyHUPAr"],["@@DX^NüTFZ@JCJaG[[kyyesKUAMHSCZ"],["@@DNnlHBFAfODMAMomKCMAI@IFIT@L"],["@@BNRfHJXAHADGDIBs@aCEGAqFEFAj"],["@@HlhHFnHdELO@MeU_a]WGW@Gh"],["@@DJV\\bf\\bJfKDGFaUkIG]CWBKN"],["@@BJzjZL@FENY@Ke_uICMJg"],["@@ZtHDxDH@vQFCRaAGQ_ECIAe@oBqbCF"],["@@DdXZ`JpBHAYFGFoAGCCkYMAmB_H]NONCL"],["@@BTZR^HXBFKB_CSIQ]CaDIPAR"],["@@BbHLLJRD`CHGDGAKK[GGKE[@MFGH"],["@@FLPVHT\\pJNfjxFFBHFtCTGLHtHHJDTBFCT[BK@§k]uYUIIQICNBDNNZbnX^CFGFIEYWQOIUEAGDCF"],["@@@F`jJJf^RFJ@LEFC@G¡IEOHAH"],["@@XXPBJEX]AOKEMCEKEIE@MPM\\@N"],["@@DLJN´ldRNEJS@GeWUGSQKKKCQ@aQODKNEL"],["@@BRFPRLLBTELM\\iPuAMQMGBEHQGHK@CCAGP_HWF[GEMCIHS`ETGv"],["@@FZVdJJh\\pJJ@`_BEWgWSYOOUBEFCL"],["@@BFDDLDRE^MTKd_JGTYR_FUBKAGK[EEECG@ODCDCFC\\CRa|eXMTUVCD@F"],["@@DFDDJ@DABA@CAEKCGDAD"],["@@BHFDJ@LCDE@MAKGGIAIBC`"],["@@NFHGCCIAGH"],["@@@BNFHAAGGCK@@F"],["@@@HLDFABCBKAGCAOD@L"],["@@XhFFXFh@DE@ICEW_GCKA[COBED@F"],["@@BFDHJHHJJJJBP@HGBWK[GCQAOBCBKR"],["@@BDhZNDN@NCFGDW@IQ[GCIAWF]`CH"],["@@JVLHLFnFHALS@MCSUMMGQAUBGDKZ@F"],["@@HLFDNCLDR@JLCXUjQRW@ECEEAyGYByAQFYNS\\CP"],["@@BPHFJBR@VChWDICMGKEAMAcJa\\AF"],["@@TbTPXLNdRLJNHN@VKNQGaDaGiIc[K[UQSAMDKpDNANCNmNAR"],["@@BHr~FDFATOTs@G]oKIKAEDcjEHAJ"],["@@FZ^JJCZ@RaCQKIQCg@KLCV"],["@@DP\\JD@FAdcBMAM_QGAGDIFG^KT"],["@@@LXXBHFDHDHFRTNBPAPOHQCMQAEECIKIMBEFBUDMKMGCKDOJGHEV"],["@@@BLVPDBADKBS@CCCICM@ABEP"],["@@@DTXHFL@PA\\[@GCGYYCAGBg`AF"],["@@BDHHHBHCFICSCCKCEBEF@T"],["@@@NBFFBrHNFbBbI@ECmM[IWCEEAOBCCAGCAYAEBEHGV@PFT@FEJ]H@F"],["@@BZlj^V\\PfNVGHWmc_MykUECBIF@D"],["@@@HFNJHL\\\\LR@PCXGDEAYCCCGG[ScEEO@EBE@GGACECCBCDCJIBELAh"],["@@LLFBN@FADAAMGEEAG@K@CFAF"],["@@FTDDTABAJS@OGIE@I@KFABCR"],["@@JZRn²ÐJFL@ZKTCDA@GOoMIÛÍGCQFAB"],["@@@DV^F@F@RSDS@EAC_KC@OVAF"],["@@BFzhhbbTj`PFfJL@TSBEISceEGDSRYNmGEAes[SEAEDKl"],["@@LhBFtxXpFFVDH@FEL]AIQ_gegaeOCBAD"],["@@@RFNJHNFVBLANEHMNeCsCKEEQ@MF[PKNGTEZ"],["@@DFDBJCBECGEAGBAJ"],["@@@FHFFBDE@KEGE@CBAB@H"],["@@BJDJj~HHJBJBLAHEFEBGCKQwKQKOOMGAOBEFK^@H"],["@@BZBDNBFA^]VUBEAEEEECG@SBWFIJAZ"],["@@BVBDFFVPPBJ@JCHGAGY]YKKAGFAH"],["@@BJHFPATIJKBIEOGCMBUVGN"],["@@NVPFjAt@HATQ@CGYACGAUAwD]BYV@D"],["@@@FDHVRlFHAFGGYGGUKM@YFABCJ"],["@@FrNTNFLA\\IJQDkCOGGIGKC[AKHKPAL"],["@@DVHH^DJ@\\KFCBKGuCEsGGBCDKn@J"],["@@BRtRJnJCc^mCsMKIA±DÓZSN"],["@@BnDTxHFND^GJCBCJeASAIY{qikAIBAj"],["@@D\\bXHBHATEIYCEYKUEI@AD"],["@@LZJBhNePeAUKI]fIVYbCNCZCL"],["@@`jlRrA`_@ca[qI_Lid"],["@@HNPVXVNBRCVMFI@QcEGWEUAIFUbE|"],["@@NHLPHRFNCLGdgNUTYTMrSnUHQFUCYCCCBMlGJ_J{XIFMLQZgvIDOAIIKc@cB{FcLILCC¸UDCACCASC{A¥BU@QLKPETA\\@"],["@@B|hL\\HÆLPAJCFI@IEGQI]E¥K]IqS"],["@@@ZP\\RPbFXBjCTKBGEGkeI[BGF"],["@@BFhNR\\BpC\\WBECEMKGAoD@qHCB"],["@@^JbATYMigA]\\@b"],["@@BHLTJBRBNABEBSCYCEaKGAEDCf"],["@@@FFJLLdBF@ZGDCHMAC]KiCEBMJCD"],["@@@FXXdADAHEFQASAEEAiEWZAF"],["@@@DHPJFFBlGTM@ACSACMAE@{TAB"],["@@FZLRFBF@^U@CAEWYG@UDCB@F"],["@@DD^BH@\\QDC@GWUCAMAGBCBQhAF"],["@@FDTDLAHCPSNYHINILMFG@GEEKAo@IDINOZOd@JBL"],["@@TLNFNBZBbATCFGDGBWGSKIYOiESAKBIDEDCFERAJDXDJ"],["@@LHJBHAHADCDG@CCEGGOCI@IDCHBJDF"],["@@IMQMICODMJCDADBFDHDDPJLPFDHDRDVADCBA@GW]"],["@@FHHFTBNAJIDGDU@GAGACEAK@]NKNAF@N"],["@@DHFDF@H@FCDEFMBGCaCCM@OBGBADAJHh"],["@@BDDDFDF@JAHCJGDMAuCEE@KBKBEDENAj@L"],["@@QRI^JfRX^JPBZEZSNY@YSYUM_KWBMF"],["@@kZWxPrlRlHtB[RcKeQ]i]iKg@kN"],["@@DFNHX@NGDGHSAMEISGOAKBKJATBX"],["@@LBP@RAXCjSRIFG@EEEECaCo@KYDMJAHAPFJHFLFhN"],["@@LFTBHEBQGQQQaKMFCNJVZV"],["@@PFLAJCTQBGAKGIMAWHIJCNAJDH"],["@@TL`LH@HIBSGMSMKAQAKDEJ@JFN"],["@@lNZFJ@LAHEDGBQISIEI@YJODK@QCM@ALDHHJ"],["@@HJHFJDHCFKXYJQHaCMIAQAcNGFENER@NFZ"],["@@FFF@BC@ICAE@ABAH"],["@@XR^HH@DE@CAGGGKCIIECQAGBCDAHDF"],["@@bXHBFAFCBGAEYQ@ECCIBMHCFDF"],["@@BBBA@AAAAD"],["@@BJJDZDPCLIJKJgAEGCGBGFKLSJEHOLEH"],["@@DVFJPDRLL\\AbCNGHe`CPDDHHJCTIZYLGRQDOK__uKKQQQGGBAL"],["@@L@DAHG@CACKCQBODADBHDDFBJCDB"],["@@PFJ@FCDG@IAOE@EBYPAH@BFD"],["@@LNJBNBDABCCEECIIKCE@ADAD@D"],["@@DFJHDADC@GCGECEACBCBBJ"],["@@DFDDJDF@BC@AGMBCHEBAAECAICK@CBADDX"],["@@DFJBT@JEDE@KCECAE@CBEFODEDAH"],["@@AJ^VHBFCBMJALAFCBMECE@IFYBSAED"],["@@@DDBF@FADA@IKIA@CBADDFCF"],["@@DJDDF@FAFAFGBEAEAA[ECBADDH@D"],["@@PXHVNHVHJALOJGBIEWWQEGIEMAgFIF@JPJ"],["@@VHDAFG@AQKI@ODABBDLF"],["@@FFF@HCDGBECGM@CDCH@H"],["@@CDBFNDXBXEDC@EIIEAIFeF"],["@@AH`Pd@xJJVGFQIa@SE}EUBS@IWUCMJFr"],["@@DFJALEFG@ECCOCIJCHBF"],["@@HBHAFCDGAEGCKBGH@HDD"],["@@@JDJDBDAHMLM@CAAKGCBMT"],["@@BNCLBJLPNBHEBEJIDI@MGOIMIGGAG@EDCJDR"],["@@@JFFHBH@NQ@CIGGCC@EBGN"],["@@@DDBB@HGBCACCAC@EL"],["@@FHFBFADC@CGCCECAGBADDF"],["@@@JDDDBFABC@GCEECCBCBBD"],["@@DBRAJA@A@AMOIEGAE@ADHZ"],["@@A\\FLH@j[PB\\JD@BEGM[[[MWCCBBPMX"],["@@JPPPHDL@RCfKRBZIRIFOBO@K[[OMSIKCMH[B]HIJKRCNBf"],["@@FHLLLZFBFABEDSFO@KBeDIHIBEQMKIKCSFIHEZIVBFHJHV"],["@@PAPKEgcqOcBSRCj@JÀZPKD_EQo[¯a{IuCXKRCpDPx "],["@@BFDBNDXEDEACY@KCCBCF"],["@@\\@JBNELKJS@GACKAC@KBSGC@WXIP@FBFLD"],["@@JCRYBE@ECCIBAHCFEBADBHABGDAF@DH@"],["@@FDhPNBHAHGJSBM@IEIMWGEICI@MFGJYj@FHL"],["@@JJTDt@XGHGHYBQqQES@OJILCRARFZJR"],["@@DBDAGGA@BH"],["@@PjFP@LCFE@KAMEKMI]S_KOAMD_XGLANDJFF"],["@@DDF@FADABGGMC@E@EDAJDH"],["@@DBF@HE@C@KAACAIBED@D@FDH"],["@@HBH@H@DCCGGCKCYQEC@KFA@AAIMEABG@A@@EEAG@ABADTZRT^Z"],["@@LHL@D@FC@EGKK@IBADAD@D"],["@@RJL@JANDNDHDDBjALM@A@C_O[EK@SFSBUHADBB"],["@@@JHFHDLEFGBM@GCECCEBGJEDGJ"],["@@HEASCGGEG@QFAHDFFDBFDJJBHA"],["@@@JDFLBHAHGJEFICIEEIEI@KDCHAR"],["@@F@D@FCDG@CIGGAA@CFCJDHDB"],["@@FAFCPM@ECEYEG@CNDNDHFB"],["@@JHD@FCFEESOME@CDEPLP"],["@@DCBFrXZEHIIG§CICIKG[AMFCFAH"],["@@RdHFtHPANCLI@OEMUUmaICK@KBGFCJAVBP"],["@@FFHBN@NEBE@GACC@]@EDAF@F"],["@@LFH@FENHXFDCAKQOSM[EoawkGQLQLENATDTJRTTPbJnHJBHEDOACSKiE[KSQq[WIkEYFQLCRHrPZtl"],["@@GBAFFJFBnBLBbJTLFLDTANINIHUDS@GEUCCWDYJKBABAF@DLDZ@rC²XPBPCPINKPaBMI]a_iUaGUAMBUH"],["@@FBF@BEDA@CEAABACC@CF@H"],["@@BBJFP@LCJIHUEIMAMDKLEJEN"],["@@AJBDFDHAFEDIACICEBEF"],["@@FFJFFAFEAGECEAI@CD@F"],["@@@FDBLBVADEBCAGGCKCIBGFCJ"],["@@BPNRDBJ@VAVM@C@MCIKWCCO@UFEHIV"],["@@EDAFBFTRZXF@FCFMCGk]IA"],["@@CBGDIV@DBDNDV@FLTE@CQWWQ"]],"encodeOffsets":[[[114139,17488]],[[114143,17487]],[[115046,17318]],[[114920,17162]],[[115340,16968]],[[114402,16941]],[[115208,16862]],[[115350,16779]],[[115376,16724]],[[114662,16716]],[[115108,16687]],[[115177,16386]],[[117685,16422]],[[117546,16276]],[[114928,16073]],[[117361,16025]],[[117008,15924]],[[120664,15498]],[[120647,15482]],[[120115,11344]],[[120516,11315]],[[117327,11037]],[[120028,10993]],[[118561,10794]],[[118504,10717]],[[118537,10713]],[[116768,10265]],[[117331,10198]],[[117292,10125]],[[117334,10121]],[[117468,9971]],[[115666,9869]],[[115213,9774]],[[116907,9610]],[[118761,9546]],[[114208,9500]],[[119552,9274]],[[116674,9088]],[[117547,8357]],[[117611,7419]],[[116327,7130]],[[115256,6123]],[[114700,3943]],[[114916,3974]],[[114943,4040]],[[115229,5934]],[[115172,5878]],[[115047,5757]],[[115224,5792]],[[115286,5696]],[[115315,5497]],[[115259,5233]],[[115355,5230]],[[115618,5113]],[[115935,6458]],[[116629,8198]],[[116840,8294]],[[117257,8316]],[[117423,8408]],[[117626,8176]],[[117708,7690]],[[116631,7790]],[[117932,8588]],[[118025,8714]],[[118282,8695]],[[112092,7521]],[[112575,8037]],[[113111,8312]],[[113112,7987]],[[113264,8204]],[[114217,7726]],[[114351,7835]],[[114232,7996]],[[114319,8097]],[[114612,8265]],[[115602,8033]],[[115656,8612]],[[115985,8322]],[[115940,8268]],[[116389,9453]],[[116366,9193]],[[116935,8975]],[[117350,9059]],[[116713,9086]],[[115582,9803]],[[115601,9815]],[[115638,9855]],[[115647,9865]],[[115714,9887]],[[114139,8730]],[[114901,9048]],[[114939,9088]],[[115043,9141]],[[115239,9059]],[[115532,9125]],[[118618,9943]],[[118831,10338]],[[118941,9810]],[[119266,10046]],[[119065,9093]],[[116999,10061]],[[116324,10487]],[[117089,9988]],[[117369,10205]],[[116985,10488]],[[117443,10595]],[[117318,10662]],[[117608,11086]],[[117450,11269]],[[117320,11593]],[[117217,11097]],[[117241,10975]],[[117442,11745]],[[117311,11010]],[[116929,11294]],[[117669,11124]],[[119985,10861]],[[120455,10884]],[[118622,11107]],[[119438,10757]],[[119637,10729]],[[120073,10569]],[[120165,10333]],[[120082,10949]],[[120598,11033]],[[120269,11331]],[[119529,11778]],[[118131,14284]],[[119496,16738]],[[120534,15547]],[[117457,16559]],[[117196,16419]],[[116955,16426]],[[116674,16216]],[[116627,16047]],[[116445,15975]],[[116594,15849]],[[116718,15790]],[[116977,15806]],[[117205,15974]],[[116691,9053]],[[116500,7821]],[[117302,10182]],[[114910,9080]],[[118496,10787]],[[118482,10760]],[[119225,10034]],[[115706,19940]],[[116565,19619]],[[116844,16389]],[[114927,17405]],[[115597,17187]],[[115428,17077]],[[113865,16169]],[[114176,16847]],[[114254,16879]],[[114265,16901]],[[114280,16933]],[[114336,16963]],[[114371,16963]],[[114372,16986]],[[114421,16854]],[[114392,16849]],[[117134,11742]],[[117095,11726]],[[117075,11704]],[[117044,11663]],[[117543,11420]],[[117058,11319]],[[117000,11341]],[[117026,11320]],[[116805,11180]],[[117110,10628]],[[117226,10628]],[[117094,10421]],[[116579,10260]],[[117138,10138]],[[117073,10127]],[[116997,10004]],[[117019,9946]],[[117142,10031]],[[117240,10088]],[[118603,11077]],[[118583,10988]],[[118135,10502]],[[118050,10437]],[[118274,10155]],[[118207,9620]],[[119285,10646]],[[119315,9976]],[[119355,9980]],[[119394,9970]],[[119253,9395]],[[114338,8881]],[[114610,8852]],[[114444,16448]],[[117283,10971]],[[117171,10929]],[[117097,10989]],[[115689,9883]],[[116524,7551]],[[117267,10171]],[[117254,10160]],[[117205,10142]],[[117261,10110]],[[117209,10077]],[[119734,9690]],[[117371,11707]],[[117418,7773]],[[114385,16599]],[[114330,16646]],[[114417,16587]],[[115732,9895]],[[115730,9909]],[[117049,10113]],[[116962,10456]],[[116960,11327]],[[117745,11345]],[[115591,9763]],[[115037,17225]]]},"properties":{"cp":[112.34882,16.831039],"name":"三沙市","childNum":220}},{"id":"460400","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@EGICEEDIEKDKEGAODIHEAIQMEKSUMGGKEW@EHGHAR@D@DEAQ@KCOBOBEHCBELABE@KGQE@GBGFIAACFMAEEBIAKAIGUHONO@GAQCSKK@KDGAQECEAE@CJGBC@CCCASLMIUBIDAJCFDL@HCHFLADEPB\\A@@CC@CFE@EFBDDF@@IFKDCAACCBABK@SCOIQEMGGCMAGDEDCHSBKDGAuCGGGAKEECEAOGIAGCKKNITEVCDEBMEUCaCCLSNQTAXAF@ZABKDIAAAAEAGE@GGEBCHCRADGHAHABKFEHEBAD@DGHEHAJGDADEPIDCNE@GGMAMIKCGCC@CFFB@DKBeKCACA[HBBFJDLBDTAAH@FHDBPHFFAFBAJHL@DC@CH@JFDH@DF@DCFEDG@@F@FGDELIJAFNLAFEDEHAFC@IIQCKBI@EGQWEMDOEEQKEEKEABMDCDGEC@G@IIGDEAE@KFEDDD@BEFADBF@DIDABEAAAA@CFEFC@@AAAAFE@DE@EEGCB@FA@CCCA@HABCEIBCRINIBIHA@EEA@ADBDAFCDAA@CGAEKCDAFABAC@CEEGD@HCDADCDA@CCBMAGC@A@W@@CFC@AAASB@ABGAAMFEFAHOAILM@AEC@A@AHA@IE@ECCO@ABEJQLGBOEECE@IFGJBH@JHNZRGP]AUBEFITINOFGFCHAJKTEHIACCAKCEEAEHEDGAWBIFCHUJODW@GBG@EEESB]NWBIEQMIWJWMGCM@KBGDEDBF@HAFCBEPAJDB@BABGDCDE`OBUHENGHKDIAEACBEHWvTVXRtX|lXhN\\Xj^b^NXHhDRDNLZ`DN@HMbELCLBd@PP^JJPHlTFHDXDFV\\JFPJL@PCFBPJBNFN@bFLDBF@LALEH@BBAJDHFD\\JN@rKFAVUFAJ@JBN@IQĘyPEDIFe@aAU@KJgDKHEXCJEHUAOAEBYAGGI@EGCKDBIKGIIEAKAKLC@@IAMDIDEDAJBNY@OEEXOJUIMAGHAF@VJJOHADEN@DCJJXBF@DCFID@@FFDBADEFBL@DBNAJB@ASEIMBEAIJACGDCBCAADGBD@JHK@AACF@@CF@@GBAAFDBEHAF@@JCDCBCBB@E@ABAAAB@BFB@DGB@FEBBGFADBBD@@EDABBNABEJKFAJJRJREBCJBIHC@DB@BFGHCDFCBH@BHBAAECCAEK@FGFABCDBHCL@DAJHPB"],["@@MEGBID@FDHRJNBP@dEjIHGBCACICGIC@KBCBI@]JCBAFM@GA"]],"encodeOffsets":[[[112404,20049]],[[112059,20391]]]},"properties":{"cp":[109.576782,19.517486],"name":"儋州市","childNum":2}},{"id":"469001","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@@AFSLKEEAK@IJKDKDANQHU@YJQDCbKDABMHMDAbAJYRFRADDBJJDF@TKFFPBREF@FFPHFFLALFNEFEPDHCFIfEBA@ECEMKGCKBGAUSAEBIHKHCHGHGBCBKAKAQ@OBCAAKCc@ECAECEFMJI@EIEEI@CFMKIAAHEDEAIBCHIBIJKDKPa@CCCAOAAAAIDEAK@MHKBEAGAIASBKEKB@IEIAGECAC@EDIEOCAGDCAIQ@EA@MJEFAHGDADE@CAIBIRGD@HCJKDK@AD@HDDJBD@H@DTAJKDCBICIDG@@AD@@EGEQGAKIEEOEGCAKCIG@EFGJaACCCAGDEHMDA@EGAOAAIEEI@SJiMI@IBMACFK@EFI@KDCBKMCMEKMMICa@CBCJGDEFGLHhAPKLE@IBAHCHEFEFONIFKRAF@LAPBHFH@DGRCPBDFB@DIP@LBFDBHADBED@B@JEZBJEH@NHJDLFFARBD@HFDBFNJDHADYbGDI@QFDFDB@DG@HF@DIJ@DBHILAHEHMBEJFBCHBFBDTLBJBFPDBFVEFCDGDCD@TJFD@LBDHBJHJ@TNHDAJNTNHHPDBNALBHBJDPBFDDHFbFZDDFCFEDALBVHRGJ@HFNCLD"],"encodeOffsets":[[112153,19488]]},"properties":{"cp":[109.516662,18.776921],"name":"五指山市","childNum":1}},{"id":"469002","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@o·}WyocGcQÉ­FUBKFCHANC@CBIEE@GFSWIQKEE@GFQTOJQ@OKHaKOOKaAQGMGOG[S[KmMWCACC@@EBCAGBGAAACE@@CCAIAM@IEE@EAA@CHC@CCG@CKII[MMDQASIYEIHMTAFADADILECGEIBGAEBKEGBEFBLDHAFKBEAAAAQHMAGA@MAIDGRMHEJA@CCIQCJEFADDLFH@BGHQDINAHCBEBIHAHGBGZFF@JBFBPGf@^KlD@PPPTLT@P@NHNEZDPHLJ@Z[NGRFVJZHRHNDT@EZJ@XFLCZQL@JBJHJDZINB`\\RBJEFEFCJBHHDPCJGJCJ@LDVHLDDZDFJ@JALCLEFUHcTCNLTDP@DFXLJf@FFBLCP@PLTPHZBHBNLLXHFHAFCPCHFL^HJNNLJLBN@VIL@JAHDFFDRJNLJJBRCTEPDVDHcFITCJCPULW@QEQBGLGDKEiBKHK`KRH`VCXBJFPDDJANGFPJDLBPCVG¬Y"],"encodeOffsets":[[113388,19844]]},"properties":{"cp":[110.466785,19.246011],"name":"琼海市","childNum":1}},{"id":"469005","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@FHFBBBAHBDLBDB@DWBBDA@ECA@AJDBDAFDBDBBFHHDLPJBFAFJFCAEFKLETBF@HFNFDFELCZEH@DDHXNBDAHIDIJAFCDM@WEIBGRBFLJBFAHCVIHBFDNEJEDCHEFAFE@MLAAC@M@BFDLK`CBC@EH@NADC@EBAFK@IFWHGFEB@BDF@PCLMPIHMFEFENGHEB fjRPPLXLXJLDRRTTTRHDL@HA\\MLM`³N_JErETE\\SRWPUZSlQbGXCPVL\\H\\ANGJKFOhÉtý~ñrģFmEUMMWIQCASE¥{{gg{qiiQGOEuEEAIM«ZUHODKAICEOMHIBCCEOAIDW_UQGODOHGLALFjCLKHAHFR@RCLKTKNIDSDEJGdHHDTAJORGFeXMBK@mQM@GDCDCJC^BLJJLFNJHNJHLDVDLHNKB@BFFDXANDCI@GAEAEAACICCBEACPBD@FCFKDCFAD@FCH@FDH@DB\\DFBD@DEHBFADBHA@FDDLBFCPF@BF@DJHBDRAHBHCBEA@DFJCDENBL@\\BDJHDJHFFNHJBFCJDJCFDDD@AHLBHFHBFF@BC@UACBADCDSBGAGDEAONEHBF@NEVHHANCBGCI@IDBDHHHADBF@JHLAPDHADF@JCF]JCBAJGLAFHTHFDBDDDPHR"],["@@@HJD@CAAFK@CA@KJ"],["@@BDB@DBB@CGEB"],["@@BB@AA@"],["@@B@A@"],["@@FFFBAGEACB"],["@@@FB@@CAA"],["@@BBAA"],["@@@BBAA@"],["@@BDDAEA"],["@@BBB@CA"],["@@BHFAHK@ECACBGJ@B"]],"encodeOffsets":[[[113296,20243]],[[113943,20459]],[[113936,20444]],[[113935,20443]],[[113930,20442]],[[113924,20438]],[[113872,20402]],[[113873,20404]],[[113875,20391]],[[113886,20359]],[[113885,20360]],[[113871,20387]]]},"properties":{"cp":[110.753975,19.612986],"name":"文昌市","childNum":12}},{"id":"469006","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@cšO@cFqDa@_EeEQMWWU_O¥[AACY@sHA[AEGCOAŁcI@KBQTY@WsW]QdWBK@KBEDAJC@QBEGMEGIKCEFIJEBOZCBKAG@CBYVGNEB]@KCC@IFGHGNARMJI^@HEV@RDJBFEX@HDL@N`JBNAF@DLHHPJ@NID@FDHPJLBBH@BDEHDRDBNDDBRRJLBJENKNGRALQXUTKVW\\FJzXTJPFHDLLDLA\\FPtPPAPBFPPBFJRDDB@FINGHQJCJ@FBBHGN@PDDJ@H@BA@CCGAKDCFCD@LFFAHBJAHFFDJKBCBCBENSJGZFTJRBNC\\NJJDLH@DDD@DGB@FBF@JFN@JBDB@DF@BDBBAHBHAD@FD@BDXDnN\\L\\TPHNHRHbBPLLPGbPLR@PIRSHEF@LFJRTXHEF@JFDAD@BMDGLEVA®E"],"encodeOffsets":[[113266,19543]]},"properties":{"cp":[110.388793,18.796216],"name":"万宁市","childNum":1}},{"id":"469007","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@BEE[SESBQEMOKGGIACAmAEKKSBSACCAECAKDM@KDMBKFGEQAECKOAEIKIDQBC@CEEAKBOHQCEBYBwOUIIGSKQQmQ_YccM@]DKAKKGFILOPKDOG{@ICUMGCTI\\ejqrapI^A^@TDTL^pp\\ZDFHTMäADaXIRUK¦ATôJFXNZbtZVYJOHUAEDKHCDE@CHKDETOBEBCDKDGJGNGTEXCNDJAfMxOD@LHFBX@LBJDPLRDFCHEHMJCNAJCp]\\BDAROPEJBJDNB`CLAHGHIDKLKBaHYFKNOFEJAL@NE@AIKOAEA@CDG@ERGF@NDHCFGBGFEDS@AEBCCEICACE@EDEDKAIICCEHIEa@EVULDREFDFH\\@FA\\QL@`GL@DCRuBA@IDC@EDYAIDICI@ECC@CGKAIMS@YMKCQBCBCNCPMDEDIDCNENK"],"encodeOffsets":[[111745,19332]]},"properties":{"cp":[108.653789,19.10198],"name":"东方市","childNum":1}},{"id":"469021","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@HBDA@AEEBEACJADMFE@GDABEAEEIWKBG@EGIAEAWAMBC@GBCHCFGBMDC@EDA@AHBBCACD@AABCAEBA@ABGB@BEDBBCFAHBBAFFLADB@CBADDD@FCEICKBIFKJEJAHGF@H@RGFBDJ@DCBFHL@HCPCDB@BFLPFBAHCJGN@BAD]BAD@HCHE@CKGUCKCIGGMMIKEIIAKD]DIDCHCH@F@nRL@NAfWHEPQBICSGGUCOCSFQDIAKIIMCQEEGCIBK@UJM@KAKIMMGIK]GEODEDGBGEKWMKGAYAOGKS@ODOAKEEe@KIEW@CCOKSDMdSVGFEDKBUEIYCCCGKCU@KDIHIDICOGGIAEDEFIFQA_[MAYJICIGIAK@YRKDWEI@DXC`DTBlDJCDBHDF@BEPABEAE@CBAFMPCEM@SGIAEHCDHJABGBCBCJBDRRBFAJEHFHKFIEC@EFCHIH@FBNCHAHCHCPHJB~LRZTJNLHRAPGTCPDJR@jBLNJRALJ@LIRORIDKBOJO@IF]NAD@NBBFBDB@DEB@DDNAFCLBN@BEBEFCHBLCDG@GCEFABECCBKKABMCAADCAGBCGA@CDAICBAGCBEI@CAACCA@EA@IFAJCDADBRTD@HI@@JAD@FC@CCCCACE@CFCFBJFFDDRHHJ@HAPKXGXFHTBHL@JHJRFNEB@FARO@CCEDIAEFGF@DA@IHAXKJOLDDAJEDKD@HDBDCHGDCJFFDHFBHJN@A`DFNHNBHHALJVAHBJH@FDF@FCFHRBJ@DBJADANEBAJDFFHPDDFJPDFBDDFBFAJEDAJFDAfCDFBT"],"encodeOffsets":[[113028,20202]]},"properties":{"cp":[110.349235,19.684966],"name":"定安县","childNum":1}},{"id":"469022","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@HCBFDBBDDBJ@AFHDABJDCB@DHBADBHCDBBNDBALLDAFDBAFEHDH@DCAKDGFEFA@AAMDKBECM@CFA@CCAEAAA@MBC^MJEP@PILAJCPQJQ@KKIQBMIAK@iIQOCSDOHQBKGIMYSKQA}GIDODGBGDGAM@EJGDGFED@JFLEEGFGBIAEQQACDIDAHABAGIDCFGJBTHN@DFNOBEDAF@FBBAFO@ACEAGDCCIAkCSD_CWFYS@MCQGYGUIQEMHY\\I@GKCOFYGM@M@OKSOSOOC@KJODO@S@eIQAKHEHAPGPSPCDCJDHEBAAAAQDEAGFCAI@CHEB@DBDEBAFCAADa@GA_CGN@FBT@HGNKNMLOFMJKBKA_AQRcnEFGDMBM@CCA@MLQBQVDdDFCJDHD^@DGDFHHDHFF@LJ@VFPLTPJJBJC@DDBDCFBHIHGJ@D@PNRBJJ@FGA@DC@@BDDJBBD@DELIAC@ADFBJBFB@F@NDJDBFED@RDNAFB@DGLICEBGB@FBFDDF@JH@LJLCH@BLBDB@DIBKN@BDHALVBZFXA`KRANBbFJCJEDIDYHKNCTFTHNJDJ@JGNDPRJLBdAPDPJAJCHILBLDD@FADEFCAABCACBBDDDCHEFBBAHNDD@FABABB@BFBBBBBADFBJHFAJ@BABB"],"encodeOffsets":[[112781,20030]]},"properties":{"cp":[110.102773,19.362916],"name":"屯昌县","childNum":1}},{"id":"469023","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@nwLIAGAMLAJKHBPCDBBDDAB@BGBICEDKGACA@EDGAAAAKYBEFAHADDHE@AKBEA@CJCBIA@CHIFADCBBEAAEAACG@ADCBA@CG@IFINKJ@FG@CMEECEIBELCHGAU@CDE@EQBGCE@@ABIDCH@NHLJFB^KBBNDDDBA@AFSGAOBGG@ENAJBHAXQBQDE@E@GGQBAJgHI@IZKDCCUFKDABACAEBEMME@KEEAIEC@ABSJAR@BIDCBAAAEMASGEBGLIF@VJrH@EIQBKGGMAICEE@cM@GIEACGEEDIHCDGACGCC@CLIFCBKCIPWLGB@JCBE@EHBFCJDF@DQPEBA@MFQEGI@IGKSAEGHWLWBO@GGIQGCCEEAIDEDEF@BDDDDDD@@EBC@IJ@@GSCAQBCDCBIBAAAABI@EBIGEABCAAAAEA@AAAABEBC@MCBGAAFEDGCCACDADBBADBFEBC@ECCAKJKDGBIOIOCcBKAQICOHM@ICIMISGSEMDGLCZCJIFIDaEMAQB_LWBYEUABKCG@ALMJA@CCAKA@ADGIK@KIGE@CCAE@EHAFAJDHK@CEAMBQCC@EFCACI@M@EEAIAEABCD@JBFK@CACIACC@AD@@CHB@EIIQAQMI@C@EHOVIBBL@JIJGBCBABHJADEBEEBGCGGEOCAI@CJCLGDABAACIBGIA@GJC@ONC@ICIGQAKKMAECAMI@AHGBE@EHEFABDJKPUFY@OLBFENBDJBHEHAF@HR@LAFKBAFGDAFAPDP@LBRCFC@Q@GBGH@FFXHLNHTVFLRNBJGFCJBPFHCLFLCJFFJDDFHDFHBHJNHT@FDBH@FGLGLAJBRELBPJCH[HENBJHFLJDDBPFHNHTDLFDJ@JDNJR@VBPFL\\`HLBXFNCNANJBBBFL@JDJDL@DEHGDEJWJADFT@JFFJD@DCLUF@FDJLBFBB\\KDI@CJCBMAGBORQDHJFBDFAHKPLBJALPFQDAHBDC@CHABCFBLNHV@^BLYFIRc¤ZFPBpCbK`OZBTÄ"],"encodeOffsets":[[112750,20508]]},"properties":{"cp":[110.007147,19.737095],"name":"澄迈县","childNum":1}},{"id":"469024","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@X|VLR~p^\\NJNDP^@^NTRJDNDP@TCN@dHL@NCTK^cZUNCXAPBLDZRNFNDR@LALG\\Kd£JQZEAK@]GUKMEAADGB@DCDGACBERKOIBKALOBGCEEAGIRCPQHANBDADIJ@LCA[EAKACI@EVEDK@CICEE@IESBCXIFIHCFG@CCKCI@IEKAAIABMDMEMAWGK[_EKAO@UIQCM@ICIKESCMGEGAOCCKIGEAIFM\\GDGOIKAQFIAKBKHEHG@CA@EGSIMAGEGEAOAIGCBK@GDCAADEBEHL@BFDDBFABAGG@DACEGDEH@ACAD@JGIAADQFQIIIEBILAFMBAACB@FC@AABCHEAAEFA@CHA@AEA@BBAB@B@FAAADCDIDBEFGCABEAB@HE@@DE@BD@BGL@IACCHBBADCDDHIBBJAFJNTF@BIAMBCAK@EACFABEC@EC@EJCDE@WAIICDM@CFGBIPUIE@GBBHJNIVWPFF@PMZIACBCFCJBN@JD@LKLBFBJJLHAJLCHD@FHJBHAZBFBPGVIFWDGFCLIhDxGrCJOF·`"],"encodeOffsets":[[112127,20351]]},"properties":{"cp":[109.687697,19.908293],"name":"临高县","childNum":1}},{"id":"469025","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@PCVIDGJEXAHBFCFGFBDFBLDDJBFGLSBIDGHEPEJMJSFEVA^BHOYQGM@IAGHIJEF@FDPFHARKFIBAP@DD@FJFB@BGB@D@BFN@JKPBBGFENEBBAH@BTABB@BED@DX@B@D@BHANDDB@DCBCDC@GHCFF@DBDBABEDCFLHB@DBBDCBEACBCB@FFB@JGJAJMDQJADFBA@GDBDDB@@EDAFH@FCFF@BEBB@BD@FEDEB@BBFBBAJC@CAEBCFE@ACCFCLEF@FBHCJJH@D@HFDCNCBALFFFRLFFCPFNRXFHJ@LARDJJD@BEFGFCBEMKBEJIFKHC@E@EH@FCDE@CCEG@EC@IDGD@@CGKBIEAEBGEAOGC@EBGSBACCKEIAA\\GDBDBfLLA@CEADED@HDLDNJNBHHF@DMJCFOBCHCBIFGHG@CBCFAFGLEBABGHGBCDQDGFAHHF@BHBFBBJBNC@[BEBWRSTMDKrFTHFADAFWJSLMCKJSBCTKBICQDKACY_YTW@IGGMAKBMAAICKIOCIBE@EGUKEG@EJ]CMGEEAKAw`OFOBIAGCCCEECE@QCMAMKCIGIEKCMDGEI@QHUGKAEBGHC@G[EaCGECOAICGAKAMBCAGOMGMSBIGCSMI@IGGAAC@G@CECSIEBEJED]HMJKCC@IFeLKFCCIDS@AHBTILADBBDFJNBD@FAHEDCFD`AFCDBJCFAHCFDLBNCH@JKDKECBM@KFINMAI@CDGDGCG@IRKHMDIAOIGAGAIBMtKXEHANFVCLIJk\\KNM^ETBLXnRrBNBRIPGHGJKLGTADIAGCK@SLKTCTIL]@QFKFSRERBRDHHHJL@VIVCNCjBNNJFRAJMXA^FTFFH@HAX@"],"encodeOffsets":[[111689,19955]]},"properties":{"cp":[109.452606,19.224584],"name":"白沙黎族自治县","childNum":1}},{"id":"469026","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@ASDcDMJU@UIKGGCGAQFQTQLERE^@JKDSLSTKL@HDJBBCHSLKHIHGJOAQAMQqWmAKFSN]LMl[JIDKEUBMFGLWNsJAHBHBPJJBNCLGJQH@HDHCDCJ@NBJMLEN@DALFLC@IDGAMCKDEBGDEAIDCBEC_DEFCBG@EACMSACLMASBGT@JC@EGOG@SUMCIGGYB[AAEAKAACEAMCOBQAGGECKDOAYNEDCHKDKDS@GGSBKGQ@EQQ[EEA@MLMFCDCJCFONMDADADDRNL@ZNTBJHL@DDD@FDJCJBJCZ@FCD@JABQvCDK@_HK@[REB[@EGECQFKCUV@FFbGJDFJDBJCLCF@FDFDBFJDDFA@BCTEFAHEHGDMCE@QH@FCH@DFBPBJL@BMFK@IBEFMPELGZAbKLCLGJGHKB_DMAICIAOFQPCB[Ao^IDMBIDGNGFEDQCOKICKAW@EAKGC@wPeNIBMCWDSFMHIHCHCLADAFSPCFGL@DCFGDCLBFGVIPUZNVZ^`N\\LXDBTDdRNNj\\XbNhLZLjXuFGDAFBJBLCHGFMVGPAF_DCHCBA@ACABIFODABE@GAEFCHCLAN@HDXNXI"],"encodeOffsets":[[111662,19897]]},"properties":{"cp":[109.053351,19.260968],"name":"昌江黎族自治县","childNum":1}},{"id":"469027","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@EAGBIEEECMGIMIMMICMKI@MKMCQGCEAKWYEIAGBELUAKEIEEIAGFGCIGA@CJANBD@FGDEBKAMRCJUPC@KDEHE@IGQG[DGBEDE@EAECCEAGBMIEAEE@AAAK@GCGCAAEAODI@IBEFADCDOAUBGEEAGIAACFE@AUKSDCDELEDIBCFCBKCCCE@ACQFQCAEABCCAD@BQFCKKCEECAIGGCWNC@QcC@ADIBKAGGCAGBQCKOKBICBAEEECKS@K@AQCYQ@CBEEEECw®apIFCBsBTqTkJÇDkHePWNQXIZGtChDbÆNIHVNJD|@PHLCPOJKHELLLB^CN@dd`ZnRRRTLJHVJxPZAFARDPGLAFBDFD@RAJCJLBFLPFDRBHFLENALCN@LCDBBFDDTBVAJLBFBnBDHJLHNPRFTATFF\\AFHFR\\FRP@NHTAHHT@XGDGFCVKFANBJCHDHHRBPANDFBDFPBBFAXHZJHNDTVH@B@FP@FDDLEfKJED@LDNIHAAEOCAEAISKCIDGEAFINAFGBGJKAGJOACECF@BAGIREJ@HCZaBCCGMIAEEC@GACBQEECKGI@MFGAIFY@I@AFCCAGBCAAE@KJO@CEAACDOHQ@CEGAGBO@KBELQJEPMFEFEDGBGJAF@LKBOGgHKFEHCDKEG"],"encodeOffsets":[[112031,19071]]},"properties":{"cp":[109.175444,18.74758],"name":"乐东黎族自治县","childNum":1}},{"id":"469028","type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[["@@@MCK@GFWAECI@IF]@GJ]NIBQHMHGLEND^@FAHMZUDAH@LBDAPYFAJIFELDHJNFFHRAD@BIFCLAL@XAcµaQe_IKQaM}U»GOKQSK¡aOA_BSFuReFsBË][[¬A@EAEHNFE\\CFCP@FDD^FDBDHBXHJBF@FEPGHINADC@Q@MHEFEPFRFDJAH@JJJAHHD@BE@EBGHAFB@FDFDELCJDNTDJALCFBNPHD@FHDB@LDF@DCHEB@F@DQCCAC@CDI@EDANAFEDG@CAGD@@@FEBEJDJ@NAH@FFXALLDHHNBJCDB@NALCHEJAHDDN@B@BJDDFRORIRGDANBD[@CBCBCN@PBDC@QIYEA@MJAD@JLNADOH@BHdAB_HABDPCLBRNLDLRRDIACBADA@CBAFGP@`[BGBGHIAOBQFOJ@B@HKPQJ@NFJ@RCDBNPJFDLBBLAJPFDFABAHQFIDAF@BHJFJHHHHLJBFFL@HJJF`DN@ROJBFEDKLGDEBKPKHIHCL@"],["@@DBBAECADB@"]],"encodeOffsets":[[[112656,19183]],[[112788,18878]]]},"properties":{"cp":[110.037218,18.505006],"name":"陵水黎族自治县","childNum":2}},{"id":"469029","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@QQCKKGACAIDSCOBA`GBAGc@APGBCKM@IDENGZFRJD@AC@ODMDADA\\@ACBMHCJQPQEQCCAIA@M@CCBGFIDGBK@MCAIDMAGGIC@KE]BOCOFIFA@EHCDBH@FCBEBMFCJ@DCD@DBRD@C@EFADG@CCE@KCAEGC@OGAMDEBKCIMSICKDCFCE@EEAGBAH@FAFA@EACEIBIIG@IBABANEJC@GHGEG@@C@QACCQMCMECDGGMGO@@CAGDECIDG@EA@EBEAKMEIAKCM@QFQ@GAA@@GJEBIJA@OS@IBE@KM@@GGE@CHMKECBEFKCAC@EC@GBCAA@IDGAIDIL@DKKE@CBCECAEACBCAAACAC@E@IEEBCDGAMNMEGISJ@DG@ABEACBEAEBICOFAH@J@FKFALCB@BOFMNANLEHHBJDH@HKJ@B@JFDBRFFCJHJJHDFCNDD@PAD@F@BAHDXAFEDOHYDEBCBATEHCCK@EBIAKFEBIFWEM@CDSJEFKDA@AACBAEAAECE@EHFJ@D@BC@CD@HKVAH@DADE@BDEFDL@PGH@DFHF@V@N@FDNNFLDNLNDALCJ@FEL@DENBJAJ@jNTIJ@FFBJPBHB@FCBGNCFBHDDBDIbEH@FJHLDDBFHFPJFBLRHHF@FC@@BH@JCJDDALCBICSG@C@IACC@GBCL@LCDI@GHCJQJADBF@BCHCBGFENIB@@FJRDBHCDBFPCJ@FBDFDBHFJ@JLALFTAJBHBFBLANGL@FBLABBBPDD@DObCLILAJGJADBJCFGFBBLJENBJNJ@HIHENDFBFFDd@LDBBLAJGHAPQFAJANDL@LDD@JGFO"],"encodeOffsets":[[112409,19261]]},"properties":{"cp":[109.70245,18.636371],"name":"保亭黎族苗族自治县","childNum":1}},{"id":"469030","type":"Feature","geometry":{"type":"Polygon","coordinates":["@@EAEDAA@CIDIAOIKSEO@UKIE@GEGCEGHC@CC]CGDICEA[AEBEPQRANKB@DDN@NAHCFEdmRQ`BLBLANIPENKLMHM@GAS@EHM`DHBb@BCDBBEFAAC@CFADGJ@DBHEFBRCBBBBFACGDIDCTOHOBOFGLGRBfJd@PCLILk@]HeAOAE@IEEHYHABGJGFADABGJMRCHG@AEGCKBCFEDMAAOOAEBOOOsEOB[CKKKGCOESIyWEIX[LUVSRWBKHQLMFMAIIKQQCAMCCACQFGACG@AAIKGOECC@MJI@GOKG@CBEAM_IK@GDGJOLALCFKHCLEFIAQPM@_CIEGIK@EEIAGKGGIGIEAGE@CBEJGRABEBECIOKBAACKIEIKEEYDIAGCKBMPGLA@I@EPARBPGJAHAH_\\O@EHAB@DCBABBDADIVIHMCK@MCIBEBORGBGHMBAD@PBRBLALADGHGHGDGLAJBFVTHBLAHDRR@DADeFEJGDCAIAGFMFKEKBEEOGEEE@QFOAEESLE@ICAICCQBQEIZaBCBGNANCBaLCDIR@ZGVMRCBCLIL@JBLFFKLET@BJFFFRF@NDN@RJLLHPBZGx_LBFBHFDNI^@FFHVLFHF@JAPDLJJDBBANBLHNJHX@ZS\\bCNDRAJSLADGPADHXBHHJBPDFFFBLHHDHBvCHALGTCDCFBHDNHHFNJRDP@TALABDDBBCDEL@JE@CCEA@FEF@DDD@@[BOACFKBGEGDK@ECIDCBAJJVKNBTDD@DADIH@DBHDDVHD@LCL@TLRDHBP@PMVGNHRDVMZ@VELOCIBAFEFGLABABEHABB@DBJFDNBLLRBJHJDD@PMD@HIB@HJJABDABCBKHID@HBFPDHFDHAHDDDBDABCGIBADAHAFEDGAQJAHK"],"encodeOffsets":[[112514,19853]]},"properties":{"cp":[109.839996,19.03557],"name":"琼中黎族苗族自治县","childNum":1}}],"UTF8Encoding":true});
}));