/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.vaadin.dcharts.metadata;

public enum CanvasOverlayObjects {

	LINE("line"), //
	HORIZONTAL_LINE("horizontalLine"), //
	DASHED_HORIZONTAL_LINE("dashedHorizontalLine"), //
	VERTICAL_LINE("verticalLine"), //
	DASHED_VERTICAL_LINE("dashedVerticalLine");

	private String object;

	private CanvasOverlayObjects(String object) {
		this.object = object;
	}

	public String getObject() {
		return object;
	}

	@Override
	public String toString() {
		return getObject();
	}

}
