/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.shade.io.prometheus.client.hotspot;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tikv.shade.io.prometheus.client.Collector;
import org.tikv.shade.io.prometheus.client.SummaryMetricFamily;

public class GarbageCollectorExports
extends Collector {
    private final List<GarbageCollectorMXBean> garbageCollectors;

    public GarbageCollectorExports() {
        this(ManagementFactory.getGarbageCollectorMXBeans());
    }

    GarbageCollectorExports(List<GarbageCollectorMXBean> garbageCollectors) {
        this.garbageCollectors = garbageCollectors;
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        SummaryMetricFamily gcCollection = new SummaryMetricFamily("jvm_gc_collection_seconds", "Time spent in a given JVM garbage collector in seconds.", Collections.singletonList("gc"));
        for (GarbageCollectorMXBean gc : this.garbageCollectors) {
            gcCollection.addMetric(Collections.singletonList(gc.getName()), gc.getCollectionCount(), (double)gc.getCollectionTime() / 1000.0);
        }
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        mfs.add(gcCollection);
        return mfs;
    }
}

