/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.types;

import com.pingcap.tidb.tipb.ExprType;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.exception.ConvertNotSupportException;
import org.tikv.common.exception.ConvertOverflowException;
import org.tikv.common.exception.InvalidCodecFormatException;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.types.Converter;
import org.tikv.common.types.DataType;
import org.tikv.common.types.MySQLType;

public class BytesType
extends DataType {
    public static final BytesType BLOB = new BytesType(MySQLType.TypeBlob);
    public static final BytesType LONG_TEXT = new BytesType(MySQLType.TypeLongBlob);
    public static final BytesType MEDIUM_TEXT = new BytesType(MySQLType.TypeMediumBlob);
    public static final BytesType TEXT = new BytesType(MySQLType.TypeBlob);
    public static final BytesType TINY_BLOB = new BytesType(MySQLType.TypeTinyBlob);
    public static final MySQLType[] subTypes = new MySQLType[]{MySQLType.TypeBlob, MySQLType.TypeLongBlob, MySQLType.TypeMediumBlob, MySQLType.TypeTinyBlob};

    protected BytesType(MySQLType tp) {
        super(tp);
    }

    protected BytesType(TiColumnInfo.InternalTypeHolder holder) {
        super(holder);
    }

    @Override
    public boolean isPushDownSupported() {
        return false;
    }

    @Override
    public long getSize() {
        if (this.isLengthUnSpecified()) {
            return this.getPrefixSize() + this.getDefaultDataSize();
        }
        return this.getPrefixSize() + this.getLength();
    }

    @Override
    protected Object decodeNotNull(int flag, CodecDataInput cdi) {
        if (flag == 2) {
            return Codec.BytesCodec.readCompactBytes(cdi);
        }
        if (flag == 1) {
            return Codec.BytesCodec.readBytes(cdi);
        }
        throw new InvalidCodecFormatException("Invalid Flag type for : " + flag);
    }

    @Override
    protected Object doConvertToTiDBType(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        return this.convertToBytes(value);
    }

    private byte[] convertToBytes(Object value) throws ConvertNotSupportException {
        byte[] result;
        if (value instanceof Boolean) {
            result = ((Boolean)value).booleanValue() ? new byte[]{49} : new byte[]{48};
        } else if (value instanceof Byte) {
            result = value.toString().getBytes();
        } else if (value instanceof Short) {
            result = value.toString().getBytes();
        } else if (value instanceof Integer) {
            result = value.toString().getBytes();
        } else if (value instanceof Long) {
            result = value.toString().getBytes();
        } else {
            if (value instanceof Float || value instanceof Double) {
                throw new ConvertNotSupportException(value.getClass().getName(), this.getClass().getName());
            }
            if (value instanceof String) {
                result = value.toString().getBytes();
            } else {
                throw new ConvertNotSupportException(value.getClass().getName(), this.getClass().getName());
            }
        }
        if ((long)result.length > this.getLength()) {
            throw ConvertOverflowException.newMaxLengthException(result.length, this.getLength());
        }
        if (this.getType() == MySQLType.TypeString && (long)result.length < this.getLength()) {
            byte[] fillZero = new byte[(int)this.getLength()];
            System.arraycopy(result, 0, fillZero, 0, result.length);
            result = fillZero;
        }
        return result;
    }

    @Override
    protected boolean isPrefixIndexSupported() {
        return true;
    }

    @Override
    protected void encodeKey(CodecDataOutput cdo, Object value) {
        byte[] bytes = Converter.convertToBytes(value);
        Codec.BytesCodec.writeBytesFully(cdo, bytes);
    }

    @Override
    protected void encodeValue(CodecDataOutput cdo, Object value) {
        byte[] bytes = Converter.convertToBytes(value);
        Codec.BytesCodec.writeCompactBytesFully(cdo, bytes);
    }

    @Override
    protected void encodeProto(CodecDataOutput cdo, Object value) {
        byte[] bytes = Converter.convertToBytes(value);
        Codec.BytesCodec.writeBytesRaw(cdo, bytes);
    }

    @Override
    public String getName() {
        return "BYTES";
    }

    @Override
    public ExprType getProtoExprType() {
        return this.getCharset().equals("binary") ? ExprType.Bytes : ExprType.String;
    }

    @Override
    public Object getOriginDefaultValueNonNull(String value, long version) {
        return value;
    }
}

