/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.predicates;

import java.util.Optional;
import org.tikv.common.expression.Expression;
import org.tikv.common.expression.visitor.DefaultVisitor;
import org.tikv.common.expression.visitor.PseudoCostCalculator;
import org.tikv.common.predicates.ScanSpec;

public class SelectivityCalculator
extends DefaultVisitor<Double, Void> {
    public static double calcPseudoSelectivity(ScanSpec spec) {
        Optional<Expression> rangePred = spec.getRangePredicate();
        double cost = 100.0;
        if (spec.getPointPredicates() != null) {
            for (Expression expr : spec.getPointPredicates()) {
                cost *= PseudoCostCalculator.calculateCost(expr);
            }
        }
        if (rangePred.isPresent()) {
            cost *= PseudoCostCalculator.calculateCost(rangePred.get());
        }
        return cost;
    }

    @Override
    protected Double process(Expression node, Void context) {
        return 1.0;
    }
}

