/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.key;

import java.util.Objects;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.codec.KeyUtils;
import org.tikv.common.exception.TypeException;
import org.tikv.common.key.Key;
import org.tikv.common.types.BytesType;
import org.tikv.common.types.DataType;
import org.tikv.common.types.IntegerType;
import org.tikv.common.types.StringType;

public class TypedKey
extends Key {
    private final DataType type;
    private final int prefixLength;

    public TypedKey(Object val, DataType type, int prefixLength) {
        super(TypedKey.encodeKey(val, type, prefixLength));
        this.type = type;
        this.prefixLength = prefixLength;
    }

    private TypedKey(byte[] val, DataType type) {
        super(val);
        this.type = type;
        this.prefixLength = -1;
    }

    public static TypedKey toTypedKey(Object val, DataType type, int prefixLength) {
        Objects.requireNonNull(type, "type is null");
        return new TypedKey(val, type, prefixLength);
    }

    public static TypedKey toTypedKey(Object val, DataType type) {
        return TypedKey.toTypedKey(val, type, -1);
    }

    private static byte[] encodeKey(Object val, DataType type, int prefixLength) {
        CodecDataOutput cdo = new CodecDataOutput();
        type.encodeKey(cdo, val, prefixLength);
        return cdo.toBytes();
    }

    public DataType getType() {
        return this.type;
    }

    public Object getValue() {
        CodecDataInput cdi = new CodecDataInput(this.value);
        return this.type.decode(cdi);
    }

    @Override
    public TypedKey nextPrefix() {
        return this.toRawTypedKey(TypedKey.prefixNext(this.value), this.type);
    }

    private TypedKey toRawTypedKey(byte[] val, DataType type) {
        return new TypedKey(val, type);
    }

    @Override
    public TypedKey next() {
        DataType tp = this.getType();
        Object val = this.getValue();
        if (tp instanceof StringType) {
            return TypedKey.toTypedKey(TypedKey.prefixNext(((String)val).getBytes()), this.type, this.prefixLength);
        }
        if (tp instanceof BytesType) {
            return TypedKey.toTypedKey(TypedKey.prefixNext((byte[])val), this.type, this.prefixLength);
        }
        if (DataType.isLengthUnSpecified(this.prefixLength)) {
            if (tp instanceof IntegerType) {
                return TypedKey.toTypedKey((Long)val + 1L, this.type);
            }
            return this.toRawTypedKey(TypedKey.prefixNext(this.value), this.type);
        }
        throw new TypeException("When prefix length is defined, type for TypedKey in next() function must be either String or Byte array. Actual: " + val.getClass().getName());
    }

    @Override
    public String toString() {
        try {
            CodecDataInput cdi = new CodecDataInput(this.value);
            Object val = this.type.decode(cdi);
            if (val instanceof byte[]) {
                return KeyUtils.formatBytes(this.value);
            }
            return val.toString();
        }
        catch (Exception e) {
            return "raw value:" + KeyUtils.formatBytesUTF8(this.value);
        }
    }
}

