/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert.factory;

import java.util.regex.Pattern;
import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.TypedStringConverter;

public final class NumericObjectArrayStringConverterFactory
implements StringConverterFactory {
    public static final StringConverterFactory INSTANCE = new NumericObjectArrayStringConverterFactory();
    static final Pattern DELIMITER = Pattern.compile("[,]");

    private NumericObjectArrayStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        if (cls.isArray()) {
            if (cls == Long[].class) {
                return LongArrayStringConverter.INSTANCE;
            }
            if (cls == Integer[].class) {
                return IntArrayStringConverter.INSTANCE;
            }
            if (cls == Short[].class) {
                return ShortArrayStringConverter.INSTANCE;
            }
            if (cls == Double[].class) {
                return DoubleArrayStringConverter.INSTANCE;
            }
            if (cls == Float[].class) {
                return FloatArrayStringConverter.INSTANCE;
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static enum FloatArrayStringConverter implements TypedStringConverter<Float[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Float[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 8);
                buf.append(array[0] != null ? array[0] : "-");
                for (int i = 1; i < array.length; ++i) {
                    buf.append(',').append(array[i] != null ? array[i] : "-");
                }
                return buf.toString();
            }

            @Override
            public Float[] convertFromString(Class<? extends Float[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                String[] split = DELIMITER.split(str);
                Float[] array = new Float[split.length];
                for (int i = 0; i < split.length; ++i) {
                    if (split[i].equals("-")) continue;
                    array[i] = Float.valueOf(Float.parseFloat(split[i]));
                }
                return array;
            }

            @Override
            public Class<?> getEffectiveType() {
                return Float[].class;
            }
        };

        private static final Float[] EMPTY;

        static {
            EMPTY = new Float[0];
        }
    }

    static enum DoubleArrayStringConverter implements TypedStringConverter<Double[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Double[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 8);
                buf.append(array[0] != null ? array[0] : "-");
                for (int i = 1; i < array.length; ++i) {
                    buf.append(',').append(array[i] != null ? array[i] : "-");
                }
                return buf.toString();
            }

            @Override
            public Double[] convertFromString(Class<? extends Double[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                String[] split = DELIMITER.split(str);
                Double[] array = new Double[split.length];
                for (int i = 0; i < split.length; ++i) {
                    if (split[i].equals("-")) continue;
                    array[i] = Double.parseDouble(split[i]);
                }
                return array;
            }

            @Override
            public Class<?> getEffectiveType() {
                return Double[].class;
            }
        };

        private static final Double[] EMPTY;

        static {
            EMPTY = new Double[0];
        }
    }

    static enum ShortArrayStringConverter implements TypedStringConverter<Short[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Short[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 3);
                buf.append(array[0] != null ? array[0] : "-");
                for (int i = 1; i < array.length; ++i) {
                    buf.append(',').append(array[i] != null ? array[i] : "-");
                }
                return buf.toString();
            }

            @Override
            public Short[] convertFromString(Class<? extends Short[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                String[] split = DELIMITER.split(str);
                Short[] array = new Short[split.length];
                for (int i = 0; i < split.length; ++i) {
                    if (split[i].equals("-")) continue;
                    array[i] = Short.parseShort(split[i]);
                }
                return array;
            }

            @Override
            public Class<?> getEffectiveType() {
                return Short[].class;
            }
        };

        private static final Short[] EMPTY;

        static {
            EMPTY = new Short[0];
        }
    }

    static enum IntArrayStringConverter implements TypedStringConverter<Integer[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Integer[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 6);
                buf.append(array[0] != null ? array[0] : "-");
                for (int i = 1; i < array.length; ++i) {
                    buf.append(',').append(array[i] != null ? array[i] : "-");
                }
                return buf.toString();
            }

            @Override
            public Integer[] convertFromString(Class<? extends Integer[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                String[] split = DELIMITER.split(str);
                Integer[] array = new Integer[split.length];
                for (int i = 0; i < split.length; ++i) {
                    if (split[i].equals("-")) continue;
                    array[i] = Integer.parseInt(split[i]);
                }
                return array;
            }

            @Override
            public Class<?> getEffectiveType() {
                return Integer[].class;
            }
        };

        private static final Integer[] EMPTY;

        static {
            EMPTY = new Integer[0];
        }
    }

    static enum LongArrayStringConverter implements TypedStringConverter<Long[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Long[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 8);
                buf.append(array[0] != null ? array[0] : "-");
                for (int i = 1; i < array.length; ++i) {
                    buf.append(',').append(array[i] != null ? array[i] : "-");
                }
                return buf.toString();
            }

            @Override
            public Long[] convertFromString(Class<? extends Long[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                String[] split = DELIMITER.split(str);
                Long[] array = new Long[split.length];
                for (int i = 0; i < split.length; ++i) {
                    if (split[i].equals("-")) continue;
                    array[i] = Long.parseLong(split[i]);
                }
                return array;
            }

            @Override
            public Class<?> getEffectiveType() {
                return Long[].class;
            }
        };

        private static final Long[] EMPTY;

        static {
            EMPTY = new Long[0];
        }
    }
}

