/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.util.HashMap;
import java.util.List;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.ast.BlockNode;
import org.mvel2.ast.NestedStatement;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.util.CompilerTools;
import org.mvel2.util.ParseTools;

public class SwitchNode
extends BlockNode
implements NestedStatement {
    protected ExecutableStatement condition;
    protected ExecutableStatement nestedStatement;
    protected SwitchNode switchCase;
    protected ExecutableStatement defaultBlock;
    protected boolean idxAlloc = false;
    protected String conditionSwitchKey;
    protected String conditionOperator = " === ";
    protected int blocSwitchEnd;
    protected List<String> conditionValues;

    public SwitchNode(char[] expr, int start, int offset, int blockStart, int blockOffset, int fields, ParserContext pCtx, int blocSwitchEnd, String conditionSwitchKey, List<String> conditionValues) {
        super(pCtx);
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        this.blockStart = blockStart;
        this.blockOffset = blockOffset;
        this.blocSwitchEnd = blocSwitchEnd;
        this.conditionSwitchKey = conditionSwitchKey;
        this.conditionValues = conditionValues;
        boolean bl = this.idxAlloc = pCtx != null && pCtx.isIndexAllocation();
        if ((fields & 0x10) != 0) {
            Object conditionStr = "";
            for (String conditionValue : this.conditionValues) {
                if (((String)conditionStr).isEmpty()) {
                    conditionStr = "(" + this.conditionSwitchKey + this.conditionOperator + conditionValue;
                    continue;
                }
                conditionStr = (String)conditionStr + " || " + this.conditionSwitchKey + this.conditionOperator + conditionValue;
            }
            if (!((String)conditionStr).isEmpty()) {
                conditionStr = (String)conditionStr + ")";
                this.condition = (ExecutableStatement)ParseTools.subCompileExpression(((String)conditionStr).toCharArray(), 0, ((String)conditionStr).length(), pCtx);
                CompilerTools.expectType(pCtx, this.condition, Boolean.class, true);
            }
            if (pCtx != null) {
                pCtx.pushVariableScope();
            }
            this.nestedStatement = (ExecutableStatement)ParseTools.subCompileExpression(expr, blockStart, blockOffset, pCtx);
            if (pCtx != null) {
                pCtx.popVariableScope();
            }
        }
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (((Boolean)this.condition.getValue(ctx, thisValue, factory)).booleanValue()) {
            return this.nestedStatement.getValue(ctx, thisValue, this.idxAlloc ? factory : new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        if (this.switchCase != null) {
            return this.switchCase.getReducedValueAccelerated(ctx, thisValue, this.idxAlloc ? factory : new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        if (this.defaultBlock != null) {
            return this.defaultBlock.getValue(ctx, thisValue, this.idxAlloc ? factory : new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        return null;
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (((Boolean)MVEL.eval(this.expr, this.start, this.offset, ctx, factory)).booleanValue()) {
            return MVEL.eval(this.expr, this.blockStart, this.blockOffset, ctx, new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        if (this.switchCase != null) {
            return this.switchCase.getReducedValue(ctx, thisValue, new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        if (this.defaultBlock != null) {
            return this.defaultBlock.getValue(ctx, thisValue, new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        return null;
    }

    @Override
    public ExecutableStatement getNestedStatement() {
        return this.nestedStatement;
    }

    public SwitchNode setCase(SwitchNode switchCase) {
        this.switchCase = switchCase;
        return this.switchCase;
    }

    public ExecutableStatement getDefaultBlock() {
        return this.defaultBlock;
    }

    public SwitchNode setDefaultBlock(char[] block, int cursor, int offset, ParserContext ctx) {
        this.defaultBlock = (ExecutableStatement)ParseTools.subCompileExpression(block, cursor, offset, ctx);
        return this;
    }

    public int getBlocSwitchEnd() {
        return this.blocSwitchEnd;
    }

    public String getConditionSwitchKey() {
        return this.conditionSwitchKey;
    }

    @Override
    public String toString() {
        return new String(this.expr, this.start, this.offset);
    }
}

