/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle.linux;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.RunnableProcessor;
import com.sun.glass.ui.monocle.input.InputDevice;
import com.sun.glass.ui.monocle.linux.AbsoluteInputCapabilities;
import com.sun.glass.ui.monocle.linux.KeyBits;
import com.sun.glass.ui.monocle.linux.LinuxEventBuffer;
import com.sun.glass.ui.monocle.linux.LinuxInputProcessor;
import com.sun.glass.ui.monocle.linux.LinuxSystem;
import com.sun.glass.ui.monocle.linux.SysFS;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.BitSet;
import java.util.Map;

public class LinuxInputDevice
implements Runnable,
InputDevice {
    private LinuxInputProcessor inputProcessor;
    private ReadableByteChannel in;
    private long fd = -1L;
    private File devNode;
    private File sysPath;
    private Map<String, BitSet> capabilities;
    private Map<Integer, AbsoluteInputCapabilities> absCaps;
    private Map<String, String> udevManifest;
    private ByteBuffer event = ByteBuffer.allocateDirect(16);
    private RunnableProcessor runnableProcessor;
    private EventProcessor processor = new EventProcessor();
    private LinuxEventBuffer buffer = new LinuxEventBuffer();
    private Map<String, String> uevent;
    private static LinuxSystem system = LinuxSystem.getLinuxSystem();

    public LinuxInputDevice(File devNode, File sysPath, Map<String, String> udevManifest) throws IOException {
        this.devNode = devNode;
        this.sysPath = sysPath;
        this.udevManifest = udevManifest;
        this.capabilities = SysFS.readCapabilities(sysPath);
        this.absCaps = AbsoluteInputCapabilities.getCapabilities(devNode, this.capabilities.get("abs"));
        this.fd = system.open(devNode.getPath(), 0);
        if (this.fd == -1L) {
            throw new IOException(system.getErrorMessage() + " on " + devNode);
        }
        int EVIOCGRAB = system.IOW(69, 144, 4);
        system.ioctl(this.fd, EVIOCGRAB, 1L);
        this.runnableProcessor = NativePlatformFactory.getNativePlatform().getRunnableProcessor();
        this.uevent = SysFS.readUEvent(sysPath);
    }

    public LinuxInputDevice(Map<String, BitSet> capabilities, Map<Integer, AbsoluteInputCapabilities> absCaps, ReadableByteChannel in, Map<String, String> udevManifest, Map<String, String> uevent) {
        this.capabilities = capabilities;
        this.absCaps = absCaps;
        this.in = in;
        this.udevManifest = udevManifest;
        this.uevent = uevent;
        this.runnableProcessor = NativePlatformFactory.getNativePlatform().getRunnableProcessor();
    }

    public void setInputProcessor(LinuxInputProcessor inputProcessor) {
        this.inputProcessor = inputProcessor;
    }

    private void readToEventBuffer() throws IOException {
        if (this.in != null) {
            this.in.read(this.event);
        } else if (this.fd != -1L) {
            int position = this.event.position();
            int bytesRead = (int)system.read(this.fd, this.event, position, this.event.limit());
            if (bytesRead == -1) {
                throw new IOException(system.getErrorMessage() + " on " + this.devNode);
            }
            this.event.position(position + bytesRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.inputProcessor == null) {
            System.err.println("Error: no input processor set on " + this.devNode);
            return;
        }
        try {
            while (true) {
                this.readToEventBuffer();
                if (this.event.position() != this.event.limit()) continue;
                this.event.flip();
                LinuxEventBuffer linuxEventBuffer = this.buffer;
                synchronized (linuxEventBuffer) {
                    if (this.buffer.put(this.event) && !this.processor.scheduled) {
                        this.runnableProcessor.invokeLater(this.processor);
                        this.processor.scheduled = true;
                    }
                }
                this.event.rewind();
            }
        }
        catch (IOException | InterruptedException e) {
            return;
        }
    }

    public LinuxEventBuffer getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQuiet() {
        LinuxEventBuffer linuxEventBuffer = this.buffer;
        synchronized (linuxEventBuffer) {
            return !this.processor.scheduled && !this.buffer.hasData();
        }
    }

    public String toString() {
        return this.devNode == null ? "Robot" : this.devNode.toString();
    }

    BitSet getCapability(String type) {
        return this.capabilities.get(type);
    }

    AbsoluteInputCapabilities getAbsoluteInputCapabilities(int axis) {
        return this.absCaps == null ? null : this.absCaps.get(axis);
    }

    String getProduct() {
        return this.uevent.get("PRODUCT");
    }

    @Override
    public boolean isTouch() {
        return "1".equals(this.udevManifest.get("ID_INPUT_TOUCHSCREEN")) || "1".equals(this.udevManifest.get("ID_INPUT_TABLET"));
    }

    @Override
    public boolean isMultiTouch() {
        if (this.isTouch()) {
            BitSet abs = this.capabilities.get("abs");
            if (abs == null) {
                return false;
            }
            return abs.get(47) || abs.get(53) && abs.get(54);
        }
        return false;
    }

    @Override
    public boolean isRelative() {
        return "1".equals(this.udevManifest.get("ID_INPUT_MOUSE"));
    }

    @Override
    public boolean is5Way() {
        int i;
        BitSet key = this.capabilities.get("key");
        if (key == null) {
            return false;
        }
        for (i = 0; i < KeyBits.KEYBITS_ARROWS.length; ++i) {
            if (key.get(KeyBits.KEYBITS_ARROWS[i])) continue;
            return false;
        }
        for (i = 0; i < KeyBits.KEYBITS_SELECT.length; ++i) {
            if (!key.get(KeyBits.KEYBITS_SELECT[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFullKeyboard() {
        BitSet key = this.capabilities.get("key");
        if (key == null) {
            return false;
        }
        for (int i = 0; i < KeyBits.KEYBITS_PC.length; ++i) {
            if (key.get(KeyBits.KEYBITS_PC[i])) continue;
            return false;
        }
        return this.is5Way();
    }

    class EventProcessor
    implements Runnable {
        boolean scheduled;

        EventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinuxInputDevice.this.buffer.startIteration();
            try {
                LinuxInputDevice.this.inputProcessor.processEvents(LinuxInputDevice.this);
            }
            catch (RuntimeException e) {
                Application.reportException((Throwable)e);
            }
            LinuxEventBuffer linuxEventBuffer = LinuxInputDevice.this.buffer;
            synchronized (linuxEventBuffer) {
                if (LinuxInputDevice.this.buffer.hasNextEvent()) {
                    LinuxInputDevice.this.runnableProcessor.invokeLater(LinuxInputDevice.this.processor);
                } else {
                    ((LinuxInputDevice)LinuxInputDevice.this).processor.scheduled = false;
                }
                LinuxInputDevice.this.buffer.compact();
            }
        }
    }
}

