/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle.input;

import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MonocleWindowManager;
import java.util.Arrays;
import java.util.Comparator;

public class TouchState {
    static Comparator<Point> pointIdComparator = (p1, p2) -> p1.id - p2.id;
    private Point[] points = new Point[1];
    private int pointCount = 0;
    private int primaryID = -1;
    private MonocleWindow window;

    MonocleWindow getWindow(boolean recalculateCache, MonocleWindow fallback) {
        if (this.window == null) {
            this.window = fallback;
        }
        if (recalculateCache) {
            Point p;
            this.window = fallback;
            if (this.primaryID >= 0 && (p = this.getPointForID(this.primaryID)) != null) {
                this.window = MonocleWindowManager.getInstance().getWindowForLocation(p.x, p.y);
            }
        }
        return this.window;
    }

    public Point getPoint(int index) {
        return this.points[index];
    }

    public Point getPointForID(int id) {
        for (int i = 0; i < this.pointCount; ++i) {
            if (id != -1 && this.points[i].id != id) continue;
            return this.points[i];
        }
        return null;
    }

    int getPrimaryID() {
        return this.primaryID;
    }

    void assignPrimaryID() {
        if (this.pointCount == 0) {
            this.primaryID = -1;
        } else if (this.primaryID <= 0) {
            this.primaryID = this.points[0].id;
        } else {
            for (int i = 0; i < this.pointCount; ++i) {
                if (this.points[i].id != this.primaryID) continue;
                return;
            }
            this.primaryID = this.points[0].id;
        }
    }

    public int getPointCount() {
        return this.pointCount;
    }

    public void clear() {
        this.pointCount = 0;
    }

    public Point addPoint(Point p) {
        if (this.points.length == this.pointCount) {
            this.points = Arrays.copyOf(this.points, this.points.length * 2);
        }
        if (this.points[this.pointCount] == null) {
            this.points[this.pointCount] = new Point();
        }
        if (p != null) {
            p.copyTo(this.points[this.pointCount]);
        }
        return this.points[this.pointCount++];
    }

    public void removePointForID(int id) {
        for (int i = 0; i < this.pointCount; ++i) {
            if (this.points[i].id != id) continue;
            if (i < this.pointCount - 1) {
                System.arraycopy(this.points, i + 1, this.points, i, this.pointCount - i - 1);
                this.points[this.pointCount - 1] = null;
            }
            --this.pointCount;
        }
    }

    public void setPoint(int index, Point p) {
        if (index >= this.pointCount) {
            throw new IndexOutOfBoundsException();
        }
        p.copyTo(this.points[index]);
    }

    public void copyTo(TouchState target) {
        target.clear();
        for (int i = 0; i < this.pointCount; ++i) {
            target.addPoint(this.points[i]);
        }
        target.primaryID = this.primaryID;
        target.window = this.window;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("TouchState[" + this.pointCount);
        for (int i = 0; i < this.pointCount; ++i) {
            sb.append(",");
            sb.append(this.points[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public void sortPointsByID() {
        Arrays.sort(this.points, 0, this.pointCount, pointIdComparator);
    }

    boolean equalsSorted(TouchState ts) {
        if (ts.pointCount == this.pointCount && ts.primaryID == this.primaryID && ts.window == this.window) {
            for (int i = 0; i < this.pointCount; ++i) {
                Point p1 = ts.points[i];
                Point p2 = this.points[i];
                if (p1.x == p2.x && p1.y == p2.y && p1.id == p2.id) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canBeFoldedWith(TouchState ts, boolean ignoreIDs) {
        if (ts.pointCount != this.pointCount) {
            return false;
        }
        if (ignoreIDs) {
            return true;
        }
        for (int i = 0; i < this.pointCount; ++i) {
            if (ts.points[i].id == this.points[i].id) continue;
            return false;
        }
        return true;
    }

    public static class Point {
        public int id;
        public int x;
        public int y;

        public void copyTo(Point target) {
            target.id = this.id;
            target.x = this.x;
            target.y = this.y;
        }

        public String toString() {
            return "TouchState.Point[id=" + this.id + ",x=" + this.x + ",y=" + this.y + "]";
        }
    }
}

