/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.monocle.MonocleApplication;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import java.io.IOException;
import java.io.InputStream;

final class MonocleCursor
extends Cursor {
    byte[] image;
    int hotspotX;
    int hotspotY;

    protected MonocleCursor(int type) {
        super(type);
        this.image = MonocleCursor.getImage(type);
        this.hotspotX = 0;
        this.hotspotY = 0;
    }

    protected MonocleCursor(int x, int y, Pixels pixels) {
        super(x, y, pixels);
    }

    void applyCursor() {
        int type = this.getType();
        if (type == -1) {
            ((MonocleApplication)Application.GetApplication()).staticCursor_setVisible(false);
        } else {
            NativeCursor cursor = NativePlatformFactory.getNativePlatform().getCursor();
            cursor.setImage(this.image);
            ((MonocleApplication)Application.GetApplication()).staticCursor_setVisible(true);
        }
    }

    protected long _createCursor(int x, int y, Pixels pixels) {
        this.hotspotX = x;
        this.hotspotY = y;
        this.image = pixels.asByteBuffer().array();
        return 1L;
    }

    private static String cursorResourceName(int cursorType) {
        switch (cursorType) {
            case 4: {
                return "ClosedHand";
            }
            case 3: {
                return "Crosshair";
            }
            case 13: {
                return "Disappear";
            }
            case 19: {
                return "Move";
            }
            case 5: {
                return "OpenHand";
            }
            case 6: {
                return "PointingHand";
            }
            case 10: {
                return "ResizeDown";
            }
            case 7: {
                return "ResizeLeft";
            }
            case 11: {
                return "ResizeLeftRight";
            }
            case 18: {
                return "ResizeNorthEast";
            }
            case 17: {
                return "ResizeNorthWest";
            }
            case 8: {
                return "ResizeRight";
            }
            case 16: {
                return "ResizeSouthEast";
            }
            case 15: {
                return "ResizeSouthWest";
            }
            case 9: {
                return "ResizeUp";
            }
            case 12: {
                return "ResizeUpDown";
            }
            case 2: {
                return "Text";
            }
            case 14: {
                return "Wait";
            }
        }
        return "Default";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getImage(int cursorType) {
        InputStream in = null;
        try {
            int read2;
            in = MonocleCursor.class.getResourceAsStream("Cursor" + MonocleCursor.cursorResourceName(cursorType) + "Translucent.raw");
            byte[] b = new byte[1024];
            for (int bytesRead = 0; bytesRead < 1024; bytesRead += read2) {
                read2 = in.read(b, bytesRead, 1024 - bytesRead);
                if (read2 >= 0) {
                    continue;
                }
                throw new IOException("Incomplete cursor resource");
            }
            byte[] read2 = b;
            return read2;
        }
        catch (IOException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

