/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.EGL;
import com.sun.glass.ui.monocle.GLException;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.linux.LinuxSystem;

public class AcceleratedScreen {
    private static long glesLibraryHandle;
    private static long eglLibraryHandle;
    protected static boolean initialized;
    long eglSurface;
    long eglContext;
    long eglDisplay;
    protected static LinuxSystem ls;

    protected long platformGetNativeDisplay() {
        return 0L;
    }

    protected long platformGetNativeWindow() {
        return 0L;
    }

    public AcceleratedScreen(int[] attributes) throws GLException, UnsatisfiedLinkError {
        this.initPlatformLibraries();
        int[] major = new int[]{0};
        int[] minor = new int[]{0};
        long nativeDisplay = this.platformGetNativeDisplay();
        long nativeWindow = this.platformGetNativeWindow();
        if (nativeDisplay == -1L) {
            throw new GLException(0, "Could not get native display");
        }
        if (nativeWindow == -1L) {
            throw new GLException(0, "Could not get native window");
        }
        this.eglDisplay = EGL.eglGetDisplay(nativeDisplay);
        if (this.eglDisplay == 0L) {
            throw new GLException(EGL.eglGetError(), "Could not get EGL display");
        }
        if (!EGL.eglInitialize(this.eglDisplay, major, minor)) {
            throw new GLException(EGL.eglGetError(), "Error initializing EGL");
        }
        if (!EGL.eglBindAPI(12448)) {
            throw new GLException(EGL.eglGetError(), "Error binding OPENGL API");
        }
        long[] eglConfigs = new long[]{0L};
        int[] configCount = new int[]{0};
        if (!EGL.eglChooseConfig(this.eglDisplay, attributes, eglConfigs, 1, configCount)) {
            throw new GLException(EGL.eglGetError(), "Error choosing EGL config");
        }
        this.eglSurface = EGL.eglCreateWindowSurface(this.eglDisplay, eglConfigs[0], nativeWindow, null);
        if (this.eglSurface == 0L) {
            throw new GLException(EGL.eglGetError(), "Could not get EGL surface");
        }
        int[] emptyAttrArray = new int[]{};
        this.eglContext = EGL.eglCreateContext(this.eglDisplay, eglConfigs[0], 0L, emptyAttrArray);
        if (this.eglContext == 0L) {
            throw new GLException(EGL.eglGetError(), "Could not get EGL context");
        }
    }

    public void enableRendering(boolean flag) {
        if (flag) {
            EGL.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext);
        } else {
            EGL.eglMakeCurrent(this.eglDisplay, 0L, 0L, this.eglContext);
        }
    }

    protected boolean initPlatformLibraries() throws UnsatisfiedLinkError {
        if (!initialized) {
            glesLibraryHandle = ls.dlopen("libGLESv2.so", 257);
            if (glesLibraryHandle == 0L) {
                throw new UnsatisfiedLinkError("Error loading libGLESv2.so");
            }
            eglLibraryHandle = ls.dlopen("libEGL.so", 257);
            if (eglLibraryHandle == 0L) {
                throw new UnsatisfiedLinkError("Error loading libEGL.so");
            }
            initialized = true;
        }
        return true;
    }

    public long getGLHandle() {
        return glesLibraryHandle;
    }

    public long getEGLHandle() {
        return eglLibraryHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean swapBuffers() {
        Object object = NativeScreen.framebufferSwapLock;
        synchronized (object) {
            EGL.eglSwapBuffers(this.eglDisplay, this.eglSurface);
        }
        return true;
    }

    static {
        initialized = false;
        ls = LinuxSystem.getLinuxSystem();
    }
}

