/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.spec.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.test4j.module.spec.IMix;
import org.test4j.module.spec.internal.ScenarioResult;
import org.test4j.module.spec.internal.StepType;
import org.test4j.tools.IKit;
import org.test4j.tools.commons.StringHelper;
import org.test4j.tools.datagen.IDataMap;

public class StepResult {
    private final ScenarioResult storyResult;
    private final String type;
    private String description;
    private String message;
    private boolean success = true;
    private Throwable exception;
    private final List<String> extras = new ArrayList<String>();

    public StepResult(ScenarioResult scenarioResult, StepType type, String description) {
        this.storyResult = scenarioResult;
        this.type = type == null ? StepType.Given.name() : type.name();
        this.description = description;
        this.message = "ok";
    }

    public void setError(Throwable e) {
        this.success = false;
        this.message = e.getMessage() == null ? e.getClass().getName() : e.getMessage();
        this.exception = e;
        this.storyResult.setException(e);
    }

    public void skip(String name) {
        this.message = "skip method:" + name;
        this.success = false;
    }

    public void extraMessage(String message) {
        this.extras.add(message);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.type).append(": ").append(this.description == null ? "" : this.description).append("\n");
        for (String extra : this.extras) {
            buff.append("\t").append(extra.trim()).append("\n");
        }
        if (this.success) {
            buff.append("\tsuccess: ").append(this.message);
        } else {
            buff.append("\tfailure: ").append(this.exception == null ? "error message" : this.exception.getClass().getName()).append(this.message.startsWith("\n") ? "" : "\n").append(this.message);
        }
        return buff.toString();
    }

    public void setDescription(String method, String description, Object[] args, Object result) {
        StringBuilder buff = new StringBuilder();
        if (!StringHelper.isBlank((String)this.description)) {
            buff.append(this.description).append("\n\t");
        }
        if (StringHelper.isBlank((String)description)) {
            buff.append(method);
        } else {
            buff.append(this.buildMethodDesc(description, args, result));
        }
        this.description = buff.toString();
    }

    private String buildMethodDesc(String description, Object[] args, Object result) {
        List<String> tokens = this.findTokenList(description);
        HashMap<Integer, String> paras = new HashMap<Integer, String>();
        this.addPara(paras, 0, result);
        int index = 1;
        for (Object arg : args) {
            this.addPara(paras, index, arg);
            ++index;
        }
        StringBuilder buff = new StringBuilder();
        tokens.forEach(token -> buff.append(this.doToken((String)token, (Map<Integer, String>)paras)));
        return buff.toString();
    }

    private String doToken(String token, Map<Integer, String> paras) {
        if (token.startsWith("{") && token.endsWith("}")) {
            Integer index = this.findIndex(token);
            return "\u3010" + paras.get(index) + "\u3011";
        }
        return token;
    }

    private Integer findIndex(String token) {
        String num = token.substring(1, token.length() - 1);
        if (StringHelper.isBlank((String)num)) {
            return 1;
        }
        try {
            return Integer.parseInt(num.trim());
        }
        catch (Exception e) {
            return 1;
        }
    }

    private void addPara(Map<Integer, String> paras, int index, Object arg) {
        try {
            String text = arg instanceof IMix ? "mix" : (arg instanceof IDataMap ? IKit.json.toJSON((Object)((IDataMap)arg).rows(), true) : IKit.json.toJSON(arg, true));
            paras.put(index, text);
        }
        catch (Throwable e) {
            paras.put(index, "\u5e8f\u5217\u5316\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private List<String> findTokenList(String description) {
        ArrayList<String> list = new ArrayList<String>();
        String temp = description;
        while (true) {
            int start = temp.indexOf("{");
            int end = temp.indexOf("}");
            if (start <= -1 || end <= -1 || start >= end) break;
            list.add(temp.substring(0, start));
            list.add(temp.substring(start, end + 1));
            temp = temp.substring(end + 1);
        }
        list.add(temp);
        return list;
    }

    public ScenarioResult getStoryResult() {
        return this.storyResult;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Throwable getException() {
        return this.exception;
    }

    public List<String> getExtras() {
        return this.extras;
    }
}

