/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.spec.internal;

import java.io.Serializable;
import java.util.function.Consumer;
import org.test4j.functions.ReturnExecutor;
import org.test4j.functions.SExecutor;
import org.test4j.module.spec.internal.IThen;
import org.test4j.module.spec.internal.ScenarioResult;
import org.test4j.module.spec.internal.SpecContext;
import org.test4j.module.spec.internal.StepType;

public class ScenarioThen
implements IThen {
    private final ScenarioResult scenario;

    ScenarioThen(ScenarioResult scenario) {
        this.scenario = scenario;
    }

    @Override
    public IThen then(String description, SExecutor lambda) throws RuntimeException {
        try {
            this.scenario.doStep(StepType.Then, description, lambda, null);
            return this;
        }
        catch (Throwable e) {
            throw new RuntimeException("\u6b65\u9aa4 - " + description + ", \u9a8c\u8bc1\u9519\u8bef\uff1a" + e.getMessage(), e);
        }
    }

    @Override
    public IThen then(SExecutor lambda) throws RuntimeException {
        try {
            this.scenario.doStep(StepType.Then, lambda, null);
            return this;
        }
        catch (Throwable e) {
            throw new RuntimeException("\u6b65\u9aa4 - \u9a8c\u8bc1\u9519\u8bef\uff1a" + e.getMessage(), e);
        }
    }

    @Override
    public <E extends Throwable> IThen want(String description, Consumer<E> consumer) throws RuntimeException {
        SExecutor & Serializable lambda = (SExecutor & Serializable)() -> {
            Throwable expected = SpecContext.getExpectedException();
            if (expected == null) {
                throw new AssertionError((Object)"Expecting an exception, but not!");
            }
            try {
                consumer.accept(expected);
            }
            catch (Throwable e) {
                throw new AssertionError("expected an Exception error: " + e.getMessage(), expected);
            }
        };
        try {
            this.scenario.doStep(StepType.Then, description, lambda, null);
            return this;
        }
        catch (Throwable e) {
            throw new RuntimeException("\u6b65\u9aa4 - \u5f02\u5e38\u9a8c\u8bc1\u9519\u8bef\uff1a" + e.getMessage(), e);
        }
    }

    @Override
    public <T> IThen wantResult(String description, Consumer<T> consumer) throws RuntimeException {
        ReturnExecutor & Serializable lambda = (ReturnExecutor & Serializable)() -> {
            try {
                consumer.accept(SpecContext.getWhenResult());
                return null;
            }
            catch (Throwable e) {
                throw new AssertionError("assert result error: " + e.getMessage(), e);
            }
        };
        try {
            this.scenario.doStep(StepType.Then, description, lambda, null);
            return this;
        }
        catch (Throwable e) {
            throw new RuntimeException("\u6b65\u9aa4 - \u6267\u884c\u7ed3\u679c\u9a8c\u8bc1\u9519\u8bef\uff1a" + e.getMessage(), e);
        }
    }
}

