/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.spec.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.test4j.functions.ReturnExecutor;
import org.test4j.functions.SExecutor;
import org.test4j.module.spec.internal.SpecContext;
import org.test4j.module.spec.internal.StepResult;
import org.test4j.module.spec.internal.StepType;
import org.test4j.module.spec.internal.TableDataAround;
import org.test4j.tools.commons.StringHelper;

public class ScenarioResult
implements Serializable {
    private static final List<String> Filter_List = new ArrayList<String>();
    private String scenarioName;
    private final List<StepResult> steps = new ArrayList<StepResult>();
    private StepResult lastStep = null;
    private Throwable exception;

    public ScenarioResult(String scenarioName) {
        this.scenarioName = scenarioName;
    }

    private static void addFilter(String filter) {
        Filter_List.add("\\s*at\\s+" + filter.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\.\\*") + "[^\\)]*\\)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStep(StepType type, String description, ReturnExecutor lambda, Class<? extends Throwable> eKlass) throws Throwable {
        block9: {
            StepResult stepResult = this.addResult(type, description);
            try {
                if (type == StepType.When) {
                    TableDataAround.ready(stepResult);
                }
                Object whenResult = lambda.doIt();
                SpecContext.setWhenResult(whenResult);
                if (eKlass != null) {
                    throw new AssertionError((Object)("not found expected exception: " + eKlass.getName()));
                }
                if (type == StepType.When) {
                    TableDataAround.check(stepResult);
                }
            }
            catch (Throwable e) {
                if (eKlass != null && !(e instanceof AssertionError)) {
                    SpecContext.setExpectedException(e);
                    break block9;
                }
                stepResult.setError(e);
                throw e;
            }
            finally {
                TableDataAround.remove();
            }
        }
    }

    public void doStep(StepType type, ReturnExecutor lambda, Class<? extends Throwable> eKlass) throws Throwable {
        this.doStep(type, null, lambda, eKlass);
    }

    public void doStep(StepType type, String description, SExecutor lambda, Class<? extends Throwable> eKlass) throws Throwable {
        this.doStep(type, description, ReturnExecutor.wrap((SExecutor)lambda), eKlass);
    }

    public void doStep(StepType type, SExecutor lambda, Class<? extends Throwable> eKlass) throws Throwable {
        this.doStep(type, null, ReturnExecutor.wrap((SExecutor)lambda), eKlass);
    }

    private StepResult addResult(StepType type, String description) {
        this.lastStep = new StepResult(this, type, description);
        this.steps.add(this.lastStep);
        return this.lastStep;
    }

    public boolean isFailure() {
        return this.exception != null;
    }

    public String scenarioResult() {
        StringBuilder buff = new StringBuilder();
        buff.append("\n\n").append("=========Scenario: ").append(this.scenarioName).append(" =============\n");
        this.steps.forEach(stepResult -> buff.append(stepResult.toString()).append("\n"));
        if (this.exception != null) {
            buff.append(StringHelper.toString((Throwable)this.exception, Filter_List));
        }
        return buff.toString();
    }

    public void setScenarioName(String scenarioName) {
        this.scenarioName = scenarioName;
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public StepResult getLastStep() {
        return this.lastStep;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    static {
        ScenarioResult.addFilter("*.lambda.");
        ScenarioResult.addFilter("java.util.");
        ScenarioResult.addFilter("org.test4j.");
        ScenarioResult.addFilter("mockit.integration.");
        ScenarioResult.addFilter("org.springframework.");
        ScenarioResult.addFilter("*\\$\\$EnhancerByCGLIB\\$\\$*");
    }
}

