/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.spec;

import java.lang.reflect.Method;
import org.test4j.Context;
import org.test4j.module.Test4JListener;
import org.test4j.module.spec.IStory;
import org.test4j.module.spec.internal.MixProxy;
import org.test4j.module.spec.internal.ScenarioResult;
import org.test4j.module.spec.internal.StoryPrinter;
import org.test4j.tools.commons.ResourceHelper;

public class StoryModuleListener
implements Test4JListener {
    private static ThreadLocal<ScenarioResult> Curr_Result = new ThreadLocal();

    public static ScenarioResult currScenario() {
        return Curr_Result.get();
    }

    public boolean init() {
        ResourceHelper.deleteFileOrDir((String)StoryPrinter.getStoryPath());
        return true;
    }

    public void beforeAll(Class testClass) {
    }

    public void beforeMethod(Object target) {
        if (target instanceof IStory) {
            MixProxy.createMixes(target);
            MixProxy.mix(target);
            Curr_Result.set(new ScenarioResult("NoName"));
        }
    }

    public void afterMethod() {
    }

    public void beforeExecute(Object target, Method testMethod) {
        if (target instanceof IStory) {
            Curr_Result.set(new ScenarioResult("NoName"));
        }
    }

    public void afterExecute(Object target, Method testMethod, Throwable testThrowable) {
        if (target instanceof IStory) {
            String scenarioPath = target.getClass().getName() + "__" + testMethod.getName();
            String scenarioName = StoryModuleListener.currScenario().getScenarioName();
            String scenarioResult = StoryModuleListener.currScenario().scenarioResult();
            StoryPrinter.print(scenarioPath, scenarioName, scenarioResult, testThrowable);
        }
        Curr_Result.remove();
    }

    public void afterAll() {
        Class testClass = Context.currTestClass();
        StoryPrinter.printScenarioIndex(testClass.getSimpleName());
    }
}

